/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    public static String formatBigDecimal(BigDecimal number) {
        if (number == null) {
            return null;
        }
        if (number.compareTo(new BigDecimal(1)) > 0) {
            NumberFormat currency = NumberFormat.getCurrencyInstance();
            String formatNumber = currency.format(number);
            formatNumber = formatNumber.replace("\uffe5", "").replace("$", "");
            return formatNumber;
        }
        return "" + number;
    }

    public static String formatLong(Long number) {
        if (number == null) {
            return null;
        }
        DecimalFormat format = new DecimalFormat("##0,000");
        String numberStr = number.toString();
        String formatNumber = "";
        long numberAbs = Math.abs(number);
        formatNumber = numberAbs >= 1000L ? format.format(number) : numberStr;
        return formatNumber;
    }

    public static boolean isPositiveNumberDecimal(String number, int bit) {
        boolean flag = false;
        if (bit < 0 || StringUtil.isBlank((CharSequence)number)) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(number);
        String decimal = String.valueOf((bigDecimal = bigDecimal.setScale(bit + 1, 0)).toPlainString());
        if (decimal.indexOf(".") != -1) {
            String pointString = decimal.split("\\.")[1];
            if ((pointString = pointString.replaceAll("(0)*$", "")).length() < bit + 1) {
                flag = true;
            }
        }
        return flag;
    }

    public static int getStrByteLength(String s) {
        int length = 0;
        if (StringUtil.isBlank((CharSequence)s)) {
            return 0;
        }
        int i = 0;
        while (i < s.length()) {
            int ascii = Character.codePointAt(s, i);
            length = ascii >= 0 && ascii <= 255 ? ++length : (length += 2);
            ++i;
        }
        return length;
    }

    public static String getStringByBytes(String str, int length) {
        if (StringUtil.isBlank((CharSequence)str) || length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        if (StringUtil.getStrByteLength(str) > length) {
            int count = 0;
            char[] chars = str.toCharArray();
            int charLength = chars.length;
            int i = 0;
            while (i < charLength) {
                int ascii = Character.codePointAt(chars, i);
                count = ascii >= 0 && ascii <= 255 ? ++count : (count += 2);
                if (count < 391) {
                    result.append(chars[i]);
                }
                ++i;
            }
        } else {
            return str;
        }
        return result.toString();
    }

    public static boolean isPositiveNumber(String str) {
        return str.matches("^[+]?(([0-9]+)([.]([0-9]+))?)$");
    }

    public static boolean isRegularTrue(String str, String regular) {
        return str.matches(regular);
    }

    public static String formatMoney(BigDecimal money) {
        String moneyUnit = "\u5143";
        BigDecimal moneyWan = new BigDecimal(10000);
        BigDecimal moneyYi = new BigDecimal(100000000);
        BigDecimal moneyWanYi = new BigDecimal("1000000000000");
        if (money == null) {
            money = new BigDecimal(0);
            moneyUnit = "\u5143";
        } else if ((money.compareTo(moneyWan) == 0 || money.compareTo(moneyWan) > 0) && money.compareTo(moneyYi) < 0) {
            money = money.divide(moneyWan, 2, 4);
            moneyUnit = "\u4e07\u5143";
        } else if ((money.compareTo(moneyYi) == 0 || money.compareTo(moneyYi) > 0) && money.compareTo(moneyWanYi) < 0) {
            money = money.divide(moneyYi, 2, 4);
            moneyUnit = "\u4ebf\u5143";
        } else if (money.compareTo(moneyWanYi) == 0 || money.compareTo(moneyWanYi) > 0) {
            money = money.divide(moneyWanYi, 2, 4);
            moneyUnit = "\u4e07\u4ebf\u5143";
        }
        return money + "," + moneyUnit;
    }

    public static String replaceSeparator(String path) {
        if (StringUtil.isNotBlank((CharSequence)path)) {
            path = path.replace("//", File.separator);
            path = path.replace("/\\", File.separator);
            path = path.replace("/", File.separator);
            path = path.replace("\\/", File.separator);
            path = path.replace("\\\\", File.separator);
            path = path.replace("\\", File.separator);
            return path;
        }
        return null;
    }

    public static String replaceHostSeparator(String path) {
        if (StringUtil.isNotBlank((CharSequence)path)) {
            path = path.replace("\\", "/").replace("//", "/");
            path = path.replace("/\\", "/").replace("\\/", "/");
            return path;
        }
        return null;
    }

    public static String removeChar(String Str, char ch) {
        StringBuffer buffer = new StringBuffer();
        int position = 0;
        while (position < Str.length()) {
            char currentChar;
            if ((currentChar = Str.charAt(position++)) == ch) continue;
            buffer.append(currentChar);
        }
        return buffer.toString();
    }

    public static String removeSpace(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim().replace(" ", "").replace(" ", "");
        str = str.replace("%20", "");
        str = str.replace(" +", "");
        str = str.replace("\\s*", "");
        return str;
    }

    public static Double strMul(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(Double.valueOf(v1));
        BigDecimal b2 = new BigDecimal(Double.valueOf(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static String getRandStr(int n) {
        Random random = new Random();
        String sRand = "";
        int i = 0;
        while (i < n) {
            String rand = String.valueOf(random.nextInt(10));
            sRand = String.valueOf(sRand) + rand;
            ++i;
        }
        return sRand;
    }
}

