/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebUtil {
    private static final String ECODING = "UTF-8";

    public static String getRequestJsonString(HttpServletRequest request) throws IOException {
        String submitMehtod = request.getMethod();
        if (submitMehtod.equals("GET")) {
            return new String(request.getQueryString().getBytes("iso-8859-1"), "utf-8").replaceAll("%22", "\"");
        }
        int contentLength = request.getContentLength();
        if (contentLength < 0) {
            return null;
        }
        byte[] buffer = new byte[contentLength];
        int i = 0;
        while (i < contentLength) {
            int readlen = request.getInputStream().read(buffer, i, contentLength - i);
            if (readlen == -1) break;
            i += readlen;
        }
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = ECODING;
        }
        return new String(buffer, charEncoding);
    }

    public static String getHTML(String fileUrl) throws Exception {
        String temp;
        StringBuffer html = new StringBuffer();
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        InputStreamReader isr = new InputStreamReader(conn.getInputStream(), ECODING);
        BufferedReader br = new BufferedReader(isr);
        while ((temp = br.readLine()) != null) {
            html.append(temp).append("\n");
        }
        br.close();
        isr.close();
        return html.toString();
    }

    public static String getUserAgent(HttpServletRequest request) {
        try {
            return request.getHeader("User-Agent");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getOsAndBrowser(HttpServletRequest request) {
        try {
            String browserDetails;
            String userAgent = browserDetails = request.getHeader("User-Agent");
            String user = userAgent.toLowerCase();
            String os = "";
            String browser = "";
            os = userAgent.toLowerCase().indexOf("windows") >= 0 ? "Windows" : (userAgent.toLowerCase().indexOf("mac") >= 0 ? "Mac" : (userAgent.toLowerCase().indexOf("x11") >= 0 ? "Unix" : (userAgent.toLowerCase().indexOf("android") >= 0 ? "Android" : (userAgent.toLowerCase().indexOf("iphone") >= 0 ? "IPhone" : "UnKnown, More-Info: " + userAgent))));
            if (user.contains("edge")) {
                browser = userAgent.substring(userAgent.indexOf("Edge")).split(" ")[0].replace("/", "-");
            } else if (user.contains("msie")) {
                String substring = userAgent.substring(userAgent.indexOf("MSIE")).split(";")[0];
                browser = String.valueOf(substring.split(" ")[0].replace("MSIE", "IE")) + "-" + substring.split(" ")[1];
            } else if (user.contains("safari") && user.contains("version")) {
                browser = String.valueOf(userAgent.substring(userAgent.indexOf("Safari")).split(" ")[0].split("/")[0]) + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1];
            } else if (user.contains("opr") || user.contains("opera")) {
                if (user.contains("opera")) {
                    browser = String.valueOf(userAgent.substring(userAgent.indexOf("Opera")).split(" ")[0].split("/")[0]) + "-" + userAgent.substring(userAgent.indexOf("Version")).split(" ")[0].split("/")[1];
                } else if (user.contains("opr")) {
                    browser = userAgent.substring(userAgent.indexOf("OPR")).split(" ")[0].replace("/", "-").replace("OPR", "Opera");
                }
            } else if (user.contains("chrome")) {
                browser = userAgent.substring(userAgent.indexOf("Chrome")).split(" ")[0].replace("/", "-");
            } else if (user.indexOf("mozilla/7.0") > -1 || user.indexOf("netscape6") != -1 || user.indexOf("mozilla/4.7") != -1 || user.indexOf("mozilla/4.78") != -1 || user.indexOf("mozilla/4.08") != -1 || user.indexOf("mozilla/3") != -1) {
                browser = "Netscape-?";
            } else if (user.contains("firefox")) {
                browser = userAgent.substring(userAgent.indexOf("Firefox")).split(" ")[0].replace("/", "-");
            } else if (user.contains("rv")) {
                String IEVersion = userAgent.substring(userAgent.indexOf("rv")).split(" ")[0].replace("rv:", "-");
                browser = "IE" + IEVersion.substring(0, IEVersion.length() - 1);
            } else {
                browser = "UnKnown, More-Info: " + userAgent;
            }
            return String.valueOf(os) + ":" + browser;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        try {
            String ip = request.getHeader("x-forwarded-for");
            if (StringUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
            if (StringUtil.isNotBlank((CharSequence)ip) && ip.indexOf(",") != -1) {
                ip = ip.split(",")[0];
            }
            return ip;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getContextPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath());
        String path = sb.toString();
        return path;
    }

    public static String getRequestURIWithParam(HttpServletRequest request) {
        return String.valueOf(request.getRequestURI()) + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public static Map<String, String> getParamMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String name = (String)enume.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    public static void addCookie(HttpServletResponse response, String domain, String path, boolean isHttpOnly, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null && !domain.isEmpty()) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        if (path != null && !path.isEmpty()) {
            cookie.setPath(path);
        }
        cookie.setHttpOnly(isHttpOnly);
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static String HtmltoText(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        try {
            String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
            String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
            String regEx_html = "<[^>]+>";
            String patternStr = "\\s+";
            Pattern p_script = Pattern.compile(regEx_script, 2);
            Matcher m_script = p_script.matcher(htmlStr);
            htmlStr = m_script.replaceAll("");
            Pattern p_style = Pattern.compile(regEx_style, 2);
            Matcher m_style = p_style.matcher(htmlStr);
            htmlStr = m_style.replaceAll("");
            Pattern p_html = Pattern.compile(regEx_html, 2);
            Matcher m_html = p_html.matcher(htmlStr);
            htmlStr = m_html.replaceAll("");
            Pattern p_ba = Pattern.compile(patternStr, 2);
            Matcher m_ba = p_ba.matcher(htmlStr);
            textStr = htmlStr = m_ba.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }
        return textStr;
    }

    public static String getHTMLToString(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("\\x26", "&amp;");
        sourcestr = sourcestr.replaceAll("\\x3c", "&lt;");
        sourcestr = sourcestr.replaceAll("\\x3e", "&gt;");
        sourcestr = sourcestr.replaceAll("\\x09", "&nbsp;&nbsp;&nbsp;&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x20", "&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x22", "&quot;");
        sourcestr = sourcestr.replaceAll("\r\n", "<br>");
        sourcestr = sourcestr.replaceAll("\r", "<br>");
        sourcestr = sourcestr.replaceAll("\n", "<br>");
        return sourcestr;
    }

    public static String getStringToHTML(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("&amp;", "\\x26");
        sourcestr = sourcestr.replaceAll("&lt;", "\\x3c");
        sourcestr = sourcestr.replaceAll("&gt;", "\\x3e");
        sourcestr = sourcestr.replaceAll("&nbsp;&nbsp;&nbsp;&nbsp;", "\\x09");
        sourcestr = sourcestr.replaceAll("&nbsp;", "\\x20");
        sourcestr = sourcestr.replaceAll("&quot;", "\\x22");
        sourcestr = sourcestr.replaceAll("<br>", "\r\n");
        sourcestr = sourcestr.replaceAll("<br>", "\r");
        sourcestr = sourcestr.replaceAll("<br>", "\n");
        return sourcestr;
    }
}

