/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util.dto;

import java.io.PrintStream;
import java.io.PrintWriter;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String UNKNOWN_ERROR_CODE = "unknow error";
    public static final String UNKNOWN_ERROR_MSG = "\u672a\u77e5\u9519\u8bef";
    private Throwable cause;
    private String errorCode;

    public BaseException(String errorMsg) {
        this("", errorMsg);
    }

    public BaseException(Throwable cause) {
        this(cause, "");
    }

    public BaseException(String errorCode, String errorMsg) {
        this(null, errorCode, errorMsg);
    }

    public BaseException(Throwable cause, String errorMsg) {
        this(cause, UNKNOWN_ERROR_CODE, errorMsg);
    }

    public BaseException(Throwable cause, String errorCode, String errorMsg) {
        super(errorMsg);
        this.cause = cause;
        this.errorCode = errorCode;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this.getCause().printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this.getCause().printStackTrace(pw);
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    @Override
    public String getMessage() {
        if (this.getCause() == null) {
            return super.getMessage();
        }
        return String.valueOf(super.getMessage()) + this.getCause().getMessage();
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

