/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.activites.facade.service;

import com.bxm.activites.facade.model.ActivityRedirectDto;
import com.bxm.activites.facade.model.IndexRequestDto;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="activitiesprod-service")
public interface ActivityLocalRenderService {
    @PostMapping(value={"/activityLocalRenderService/getActivityHtml"}, produces={"application/json;charset=UTF-8"})
    public byte[] getActivityHtml(@RequestBody IndexRequestDto var1);

    @PostMapping(value={"/activityLocalRenderService/getEmptyActivityHtml"}, produces={"application/json;charset=UTF-8"})
    public byte[] getEmptyActivityHtml(@RequestBody ActivityRedirectDto var1);

    @RequestMapping(value={"/activityLocalRenderService/getEmptyActivityHtmlForUrl"})
    public byte[] getEmptyActivityHtmlForUrl(@RequestParam(value="url") String var1);

    default public String encode(String url) {
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    default public String decode(String url) {
        try {
            return URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }
}

