/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.cashcat.youmi;

import com.bxm.adsmanager.model.dao.overseas.OverseasGeneralMaterial;
import com.bxm.adsmanager.timer.cashcat.youmi.Creative;
import com.bxm.adsmanager.timer.cashcat.youmi.Video;
import com.bxm.warcar.utils.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Constants {
    public static String getTrackingLinkParameter(Map<String, Boolean> mandatoryDevice) {
        if (CollectionUtils.isEmpty(mandatoryDevice)) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : mandatoryDevice.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            params.add(entry.getKey());
        }
        return JsonHelper.convert(params);
    }

    public static String getTrafficSource(String traffic, String streamType) {
        ArrayList<String> trafficSource = new ArrayList<String>();
        if (!StringUtils.isEmpty(traffic)) {
            trafficSource.add(traffic);
        }
        if (!StringUtils.isEmpty(streamType)) {
            trafficSource.add(streamType);
        }
        if (CollectionUtils.isEmpty(trafficSource)) {
            return null;
        }
        return JsonHelper.convert(trafficSource);
    }

    public static String getCreative(List<Creative> creatives) {
        if (CollectionUtils.isEmpty(creatives)) {
            return null;
        }
        ArrayList<OverseasGeneralMaterial> overseasGeneralMaterials = new ArrayList<OverseasGeneralMaterial>();
        for (Creative creative : creatives) {
            OverseasGeneralMaterial overseasGeneralMaterial = new OverseasGeneralMaterial();
            BeanUtils.copyProperties(creative, overseasGeneralMaterial);
            overseasGeneralMaterials.add(overseasGeneralMaterial);
        }
        return JsonHelper.convert(overseasGeneralMaterials);
    }

    public static String getIcon(String icon) {
        if (StringUtils.isEmpty(icon)) {
            return null;
        }
        ArrayList<OverseasGeneralMaterial> overseasGeneralMaterials = new ArrayList<OverseasGeneralMaterial>();
        OverseasGeneralMaterial overseasGeneralMaterial = new OverseasGeneralMaterial();
        overseasGeneralMaterial.setUrl(icon);
        overseasGeneralMaterials.add(overseasGeneralMaterial);
        return JsonHelper.convert(overseasGeneralMaterials);
    }

    public static String getVideo(List<Video> videos) {
        if (CollectionUtils.isEmpty(videos)) {
            return null;
        }
        ArrayList<OverseasGeneralMaterial> overseasGeneralMaterials = new ArrayList<OverseasGeneralMaterial>();
        for (Video video : videos) {
            OverseasGeneralMaterial overseasGeneralMaterial = new OverseasGeneralMaterial();
            BeanUtils.copyProperties(video, overseasGeneralMaterial);
            overseasGeneralMaterials.add(overseasGeneralMaterial);
        }
        return JsonHelper.convert(overseasGeneralMaterials);
    }
}

