/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.old;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.base.Mail;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.role.RoleService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.adsmanager.utils.MailUtil;
import com.bxm.util.AliYunSmsUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AdvertiserJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserJob.class);
    private static final String DDJobUrl = "https://oapi.dingtalk.com/robot/send?access_token=";
    public static final String MONEYINFUFFICIENT = "moneyInsufficient";
    public static final String PRESETALARM = "Alarm";
    @Value(value="${warn.ddToken}")
    private String warnDdToken;
    @Value(value="${jobControl}")
    private String state;
    @Value(value="${smsSecret}")
    private String smsSecret;
    @Value(value="${smsKey}")
    private String smsKey;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RedisClient redisClient;
    private static final Integer ZERO = 0;

    public void saveAdvertiserAndTicket() throws Exception {
        if (this.state.equals("0")) {
            return;
        }
        Long start = System.currentTimeMillis();
        try {
            String key;
            LOGGER.info("\u4fdd\u5b58\u5e7f\u544a\u4e3b\u4fe1\u606f\u5f00\u59cb\u4e86--------------");
            List<AdvertiserDto> advertiserList = this.adShopIntegration.getAdShopList(null);
            if (advertiserList == null || advertiserList.isEmpty()) {
                DingtalkMsgUtil.sendMsg(DDJobUrl + this.warnDdToken, "\u6bcf\u5c0f\u65f6\u5b9a\u65f6\u4efb\u52a1\uff0csaveNewRedisAdCertificateMsgNew \u67e5\u8be2\u6240\u6709\u5e7f\u544a\u4e3b\u8bb0\u5f55\u4e3a\u7a7a -----------", false, null);
            }
            AdTicketSearchDto adTicketSearchDto = new AdTicketSearchDto();
            adTicketSearchDto.setSettleType((short)1);
            List<AdTicket> list = this.adTicketService.queryTicketListByCondition(adTicketSearchDto);
            HashMap<String, String> map = new HashMap<String, String>();
            for (AdTicket l : list) {
                key = l.getAdvertiser() + "";
                String value = (String)map.get(key);
                if (value != null) {
                    map.put(key, value + "," + l.getId().toString());
                    continue;
                }
                map.put(key, l.getId().toString());
            }
            for (AdvertiserDto advertiser1 : advertiserList) {
                advertiser1.setBalance(this.getBalance(advertiser1));
                key = advertiser1.getId().toString();
                advertiser1.setCertificateIds((String)map.get(key));
                String saleMobile = "";
                if (advertiser1.getSale() != null) {
                    saleMobile = this.roleService.getUserMobile(advertiser1.getSale());
                }
                advertiser1.setSaleMobiel(saleMobile);
                this.redisClient.set(ZERO, "advertiser:adshop:" + key, JSON.toJSONString(advertiser1));
            }
            Long end = System.currentTimeMillis();
            Date date = new Date(start);
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
            String time = sim.format(date);
            LOGGER.info("\u5e7f\u544a\u4e3b\u4fe1\u606fredis\u66f4\u65b0\u5b8c\u6210,\u8017\u65f6:" + (end - start) + "ms:\u5f53\u524d\u65f6\u95f4" + time);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u5668\u6bcf\u5c0f\u65f6\u66f4\u65b0\u4fdd\u5b58\u5e7f\u544a\u4e3b\u4fe1\u606f\u4ee5\u53ca\u5bf9\u5e94\u4e0b\u9762\u7684\u7684\u6240\u6709\u793c\u5238\u51fa\u9519" + e.getMessage(), e);
            DingtalkMsgUtil.sendMsg(DDJobUrl + this.warnDdToken, "\u5b9a\u65f6\u5668\u6bcf\u5c0f\u65f6\u66f4\u65b0\u4fdd\u5b58\u5e7f\u544a\u4e3b\u4fe1\u606f\u4ee5\u53ca\u5bf9\u5e94\u4e0b\u9762\u7684\u7684\u6240\u6709\u793c\u5238\u51fa\u9519 -----------" + e, false, null);
        }
    }

    @Deprecated
    public void adShopMoneyAlarm() {
        if (this.state.equals("0")) {
            return;
        }
        try {
            LOGGER.info("\u5e7f\u544a\u4e3b\u9884\u8bbe\u91d1\u989d\u62a5\u8b66\u5f00\u59cb\u4e86--------------");
            String[] adShopIds = new String[]{};
            String result = this.redisClient.get(ZERO, "adShopMoneyAlarm");
            if (StringUtils.isNotEmpty(result)) {
                adShopIds = result.split(",");
            }
            if (adShopIds.length > ZERO) {
                for (String adShop : adShopIds) {
                    String adShopKey = adShop + PRESETALARM;
                    if (!StringUtils.isEmpty(this.redisClient.get(ZERO, adShopKey))) continue;
                    AdvertiserDto advertiser = JSONObject.parseObject(this.redisClient.get(ZERO, "advertiser:adshop:" + adShop), AdvertiserDto.class);
                    this.toMessage(PRESETALARM, advertiser, AdvertiserJob.getParms(null, String.valueOf(advertiser.getPresetMoney())), AdvertiserJob.getParms(advertiser.getCompany(), String.valueOf(advertiser.getPresetMoney())), AdvertiserJob.setTemplate("\u60a8\u7684\u5e7f\u544a\u8d26\u6237\u4f59\u989d\u5df2\u4e0d\u8db3" + advertiser.getPresetMoney() + "\u5143\uff0c\u4e3a\u907f\u514d\u5e7f\u544a\u505c\u6b62\u6295\u653e\uff0c\u8bf7\u5c3d\u5feb\u5b89\u6392\u5145\u503c"), "SMS_115065043", "SMS_114185025", "\u5e7f\u544a\u4e3b\u9884\u8bbe\u91d1\u989d\u63d0\u9192");
                    LOGGER.info("\u6709\u5e7f\u544a\u4e3b\u8d26\u6237\u4f59\u989d\u4e0d\u8db3----------------------");
                }
            }
        }
        catch (Exception e) {
            DingtalkMsgUtil.sendMsg(DDJobUrl + this.warnDdToken, "adShopMoneyAlarm", false, null);
        }
    }

    public static String setTemplate(String message) {
        String str = "</br><p>\u5c0a\u656c\u7684\u5e7f\u544a\u4e3b,\u60a8\u597d\uff01</p><p>" + message + "</p></br><p style='width:100%;text-align:center; background:#ccc;'>\u767b\u5f55\u67e5\u8be2  <a href='http://cpc.bianxianmao.com/'>http\uff1a//cpc.bianxianmao.com/</a></p></br><p>\u5982\u679c\u60a8\u6ca1\u6709\u6ce8\u518c\u8fc7\u53d8\u73b0\u732b\uff0c\u8bf7\u5ffd\u7565\u6b64\u90ae\u4ef6\u3002</p><p style='width:100%;text-align:right;'>\u5ba2\u670d\u7535\u8bdd\uff1a400 630 5186</p>";
        return str;
    }

    public BigDecimal getBalance(AdvertiserDto advertiser1) {
        BigDecimal balance = advertiser1.getBalance();
        try {
            balance = advertiser1.getBalance().add(advertiser1.getRebateMoney()).add(advertiser1.getCreditMoney());
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage(), e);
        }
        return balance;
    }

    public static String getParms(String str1, String str2) {
        JSONObject jsonObject1 = new JSONObject();
        if (StringUtils.isNotEmpty(str1)) {
            jsonObject1.put("advertiserName", (Object)str1);
        }
        if (StringUtils.isNotEmpty(str2)) {
            jsonObject1.put("money", (Object)str2);
        }
        return jsonObject1.toJSONString();
    }

    private void toMessage(String adShopKey, AdvertiserDto advertiser, String mosgContent, String mosgContent2, String emailMessage, String msgTemplateCode, String msgTemplateCode2, String title) {
        try {
            String key = advertiser.getId() + adShopKey;
            if (StringUtils.isEmpty(this.redisClient.get(ZERO, key))) {
                if (this.redisClient.get(ZERO, "isAlarm").equals("success")) {
                    AdvertiserJob.sendEmailMsg(title, emailMessage, advertiser.getEmail());
                    AliYunSmsUtil.sendMsg(this.smsKey, this.smsSecret, "\u53d8\u73b0\u732b", advertiser.getMobile(), mosgContent, msgTemplateCode);
                }
                if (advertiser.getSaleMobiel() != null) {
                    AliYunSmsUtil.sendMsg(this.smsKey, this.smsSecret, "\u53d8\u73b0\u732b", advertiser.getSaleMobiel(), mosgContent2, msgTemplateCode2);
                }
                this.redisClient.set(ZERO, key, "success");
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            return;
        }
    }

    public static void sendEmailMsg(String title, String message, String sendUser) {
        Mail mail = new Mail();
        mail.setHost("smtp.mxhichina.com");
        mail.setSender("service@bianxianmao.com");
        mail.setReceiver(sendUser);
        mail.setUsername("service@bianxianmao.com");
        mail.setPassword("ABCabc123");
        mail.setSubject(title);
        mail.setMessage(message);
        new MailUtil().send(mail);
    }
}

