/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.positionweight;

import com.bxm.adsmanager.dal.mapper.mediamanager.AdTicketPositionWeightNewMapper;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeightNew;
import com.bxm.adsmanager.model.dto.AdTicketPositionWeightNewDTO;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class PositionWeightJob {
    private static final Logger log = LoggerFactory.getLogger(PositionWeightJob.class);
    @Autowired
    private AdTicketPositionWeightNewMapper adTicketPositionWeightNewMapper;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private Environment environment;

    public void deleteExpiredPositionWeight() {
        AdTicketPositionWeightNewDTO dto = new AdTicketPositionWeightNewDTO();
        List<AdTicketPositionWeightNew> all = this.adTicketPositionWeightNewMapper.findAll(dto);
        if (CollectionUtils.isEmpty(all)) {
            return;
        }
        for (AdTicketPositionWeightNew weight : all) {
            boolean afterStopTime;
            Date stopTime = weight.getStopTime();
            if (null == stopTime) continue;
            List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
            if (!activeProfiles.contains("dev") && !activeProfiles.contains("test")) {
                stopTime = DateUtil.increaseHour(stopTime, 13);
            }
            if (!(afterStopTime = new Date().after(stopTime))) continue;
            AdTicketPositionWeightNew adTicketPositionWeightNew = new AdTicketPositionWeightNew();
            adTicketPositionWeightNew.setId(weight.getId());
            adTicketPositionWeightNew.setStatus(-1);
            this.adTicketPositionWeightNewMapper.updateByPrimaryKeySelective(adTicketPositionWeightNew);
            this.updater.hremove(TicketKeyGenerator.positionTicketWeightNew(weight.getPositionId()), weight.getTicketId().toString());
            log.info("\u3010\u5e7f\u544a\u4f4d\u6743\u91cd\u5230\u671f\u5220\u9664\u3011id:{},\u5e7f\u544a\u4f4did:{},\u505c\u6b62\u65f6\u95f4:{},weight:{}", weight.getId(), weight.getPositionCode(), DateUtil.dateTo14String(stopTime), JsonHelper.convert(weight));
        }
    }
}

