/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.postitiontag;

import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PositionTagJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionTagJob.class);
    @Autowired
    @Qualifier(value="jedisFetcherForFM")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdaterForFM")
    private Updater updater;
    @Autowired
    private TblAdTagService tblAdTagService;

    public void updateAllPositionTag() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u66f4\u65b0\u4fdd\u5b58\u5e7f\u544a\u4f4d\u6807\u7b7e\u4fe1\u606f\u7684job\uff0c\u6267\u884c\u5f00\u59cb");
        }
        long start = System.currentTimeMillis();
        List<TblAdTagVo> allClassTag = this.tblAdTagService.findAllClassTag();
        Map<String, String> tagMap = allClassTag.stream().collect(Collectors.toMap(vo -> vo.getCode().toString(), vo -> vo.getFullCodePath()));
        this.updater.hmupdate(TicketKeyGenerator.Tags.getTags(), tagMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u66f4\u65b0\u4fdd\u5b58\u5e7f\u544a\u4f4d\u6807\u7b7e\u4fe1\u606f\u7684job\u6267\u884c\u5b8c\u6210,\u7528\u65f6\uff1a{} ms!", (Object)(System.currentTimeMillis() - start));
        }
    }
}

