/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.timer.precharge;

import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitAllMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitPositionMapperExt;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeConfigMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargePositionRecordMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeRecordMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitAll;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dao.precharge.PrechargeConfig;
import com.bxm.adsmanager.model.dao.precharge.PrechargeConfigExample;
import com.bxm.adsmanager.model.dao.precharge.PrechargePositionRecord;
import com.bxm.adsmanager.model.dao.precharge.PrechargeRecord;
import com.bxm.adsmanager.model.dao.precharge.PrechargeRecordExample;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class PrechargeJob {
    private static final Logger logger = LoggerFactory.getLogger(PrechargeJob.class);
    @Autowired
    private AdProfitPositionMapperExt adProfitPositionMapperExt;
    @Autowired
    private PrechargeConfigMapper prechargeConfigMapper;
    @Autowired
    private PrechargeRecordMapper prechargeRecordMapper;
    @Autowired
    private PrechargePositionRecordMapper prechargePositionRecordMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    @Qualifier(value="dingDingMessageSender")
    private MessageSender messageSender;
    @Autowired
    private AdProfitAllMapperExt adProfitAllMapperExt;

    public void updatePrechargeRecord() {
        logger.info("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5f00\u59cb\u6267\u884c");
        String date = DateUtil.dateTo8String(com.bxm.util.DateUtil.getTheDayBefore(new Date()));
        PrechargeRecordExample example = new PrechargeRecordExample();
        example.createCriteria().andDatetimeEqualTo(date).andTypeEqualTo(PrechargeRecord.TYPE_CONSUME).andRecordTypeEqualTo(PrechargeRecord.RECORD_TYPE_NORMAL);
        long count = this.prechargeRecordMapper.countByExample(example);
        if (count > 0L) {
            logger.info("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5df2\u6709\u6628\u65e5\u65e5\u671f\u7684\u6570\u636e\uff0c\u672c\u6b21\u6267\u884c\u4e0d\u505a\u4efb\u4f55\u66f4\u65b0");
            return;
        }
        AdProfitAll adProfitAll = this.adProfitAllMapperExt.findAdProfitAllBydatetime(date);
        if (adProfitAll == null || adProfitAll != null && ObjectUtils.notEqual((short)1, adProfitAll.getStatus())) {
            logger.info("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011tbl_ad_profit_all\u8868status\u4e3a{}\uff0c\u6570\u636e\u8fd8\u672a\u5f55\u5165\uff0c\u672c\u6b21\u6267\u884c\u4e0d\u505a\u4efb\u4f55\u66f4\u65b0", (Object)adProfitAll.getStatus());
            return;
        }
        List<AdProfitPosition> positionByDatetime = this.adProfitPositionMapperExt.findPositionByDatetimeV2(date);
        if (CollectionUtils.isEmpty(positionByDatetime)) {
            logger.info("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011tbl_ad_profit_position\u8868\u65e0\u6628\u65e5\u7684\u5e7f\u544a\u4f4d\u8bb0\u5f55");
            this.messageSender.send2(this.getDingdingMessage("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011tbl_ad_profit_position\u8868\u65e0\u5bf9\u5e94\u7684\u5e7f\u544a\u4f4d\u8bb0\u5f55"));
            return;
        }
        Map<String, AdProfitPosition> positionProfitMap = positionByDatetime.stream().collect(Collectors.toMap(p -> p.getPositionId(), p -> p));
        List<PrechargeConfig> prechargeConfigs = this.prechargeConfigMapper.selectByExampleWithBLOBs(new PrechargeConfigExample());
        if (CollectionUtils.isEmpty(prechargeConfigs)) {
            return;
        }
        HashSet positionSet = new HashSet();
        prechargeConfigs.stream().forEach(p -> {
            String positions = p.getPositions();
            if (StringUtils.isBlank(positions)) {
                return;
            }
            List<String> positionList = Arrays.asList(positions.split(","));
            if (CollectionUtils.isEmpty(positionList)) {
                return;
            }
            positionSet.addAll(positionList);
        });
        List<AppEntranceAdRO> listByPositionIds = this.newAppEntranceFacadeIntegration.findListByPositionIds(new ArrayList<String>(positionSet));
        Map<String, String> positionNameMap = listByPositionIds.stream().collect(Collectors.toMap(p -> p.getPositionId(), p -> p.getAppEntranceName()));
        prechargeConfigs.forEach(p -> {
            PrechargeRecord prechargeRecord;
            int i1;
            int i;
            String positions = p.getPositions();
            if (StringUtils.isBlank(positions)) {
                return;
            }
            List<String> positionList = Arrays.asList(positions.split(","));
            if (CollectionUtils.isEmpty(positionList)) {
                return;
            }
            AtomicInteger accountTotalDeduct = new AtomicInteger();
            Long accountId = p.getId();
            positionList.forEach(positionId -> {
                AdProfitPosition adProfitPosition = (AdProfitPosition)positionProfitMap.get(positionId);
                if (adProfitPosition != null) {
                    PrechargePositionRecord prechargePositionRecord = new PrechargePositionRecord();
                    prechargePositionRecord.setAccountId(accountId);
                    prechargePositionRecord.setConsume(PrechargeJob.parseAmountOfYuan(adProfitPosition.getProfitActual()));
                    prechargePositionRecord.setDatetime(date);
                    prechargePositionRecord.setPositionName((String)positionNameMap.get(positionId));
                    prechargePositionRecord.setPositionId((String)positionId);
                    int i = this.prechargePositionRecordMapper.insertSelective(prechargePositionRecord);
                    if (i == 0) {
                        logger.error("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u65b0\u589e\u5e7f\u544a\u4f4d\u8bb0\u5f55\u5931\u8d25\uff0caccountId = {}", (Object)accountId);
                        this.messageSender.send2(this.getDingdingMessage("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u65b0\u589e\u5e7f\u544a\u4f4d\u8bb0\u5f55\u5931\u8d25\uff0caccountId = " + accountId));
                    }
                    accountTotalDeduct.addAndGet(adProfitPosition.getProfitActual());
                }
            });
            BigDecimal accountTotalDeductYuan = PrechargeJob.parseAmountOfYuan(accountTotalDeduct.get());
            if (accountTotalDeduct.get() != 0 && (i = this.prechargeConfigMapper.updateBalanceDeduct(accountId, accountTotalDeductYuan)) == 0) {
                logger.error("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u6263\u9664\u91d1\u989d\u5931\u8d25\uff0caccountId = {}", (Object)accountId);
                this.messageSender.send2(this.getDingdingMessage("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u6263\u9664\u91d1\u989d\u5931\u8d25\uff0caccountId = " + accountId));
            }
            if ((i1 = this.prechargeRecordMapper.insertSelective(prechargeRecord = this.buildPrechargeRecord((PrechargeConfig)p, accountTotalDeductYuan, date))) == 0) {
                logger.error("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u65b0\u589e\u6d88\u8017\u8bb0\u5f55\u5931\u8d25\uff0caccountId = {}", (Object)accountId);
                this.messageSender.send2(this.getDingdingMessage("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u65b0\u589e\u6d88\u8017\u8bb0\u5f55\u5931\u8d25\uff0caccountId =" + accountId));
            }
        });
        logger.info("\u3010\u9884\u5145\u7ba1\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u6267\u884c\u5b8c\u6bd5\uff01");
    }

    private PrechargeRecord buildPrechargeRecord(PrechargeConfig p, BigDecimal accountTotalDeductYuan, String date) {
        PrechargeRecord prechargeRecord = new PrechargeRecord();
        prechargeRecord.setAccountId(p.getId());
        prechargeRecord.setAccountName(p.getAccountName());
        prechargeRecord.setConsumeAmount(accountTotalDeductYuan);
        prechargeRecord.setBalance(p.getBalance().subtract(accountTotalDeductYuan));
        prechargeRecord.setDatetime(date);
        prechargeRecord.setType(PrechargeRecord.TYPE_CONSUME);
        return prechargeRecord;
    }

    public static BigDecimal parseAmountOfYuan(Integer amountOfLi) {
        BigDecimal amountOfYuan = new BigDecimal(amountOfLi).divide(new BigDecimal(1000), 2, 4);
        return amountOfYuan;
    }

    private Message getDingdingMessage(String content) {
        Message message = new Message();
        message.setContent(content);
        message.setTos(null);
        return message;
    }
}

