/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public final class StringValue
extends ASTNodeAccessImpl
implements Expression {
    private String value = "";
    private Character prefix = null;
    public static final List<Character> ALLOWED_PREFIXES = Arrays.asList(Character.valueOf('N'), Character.valueOf('U'), Character.valueOf('E'));

    public StringValue(String escapedValue) {
        char p;
        if (escapedValue.startsWith("'") && escapedValue.endsWith("'")) {
            this.value = escapedValue.substring(1, escapedValue.length() - 1);
            return;
        }
        if (escapedValue.length() > 2 && ALLOWED_PREFIXES.contains(Character.valueOf(p = Character.toUpperCase(escapedValue.charAt(0)))) && escapedValue.charAt(1) == '\'' && escapedValue.endsWith("'")) {
            this.prefix = Character.valueOf(p);
            this.value = escapedValue.substring(2, escapedValue.length() - 1);
            return;
        }
        this.value = escapedValue;
    }

    public String getValue() {
        return this.value;
    }

    public Character getPrefix() {
        return this.prefix;
    }

    public String getNotExcapedValue() {
        StringBuilder buffer = new StringBuilder(this.value);
        int index = 0;
        int deletesNum = 0;
        while ((index = this.value.indexOf("''", index)) != -1) {
            buffer.deleteCharAt(index - deletesNum);
            index += 2;
            ++deletesNum;
        }
        return buffer.toString();
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setPrefix(Character prefix) {
        this.prefix = prefix;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return (this.prefix != null ? this.prefix : "") + "'" + this.value + "'";
    }
}

