#!/bin/bash

ACTIVE="$1"
if [ -z "$ACTIVE" ]; then
  ACTIVE="test"
  echo "Use default profile: $ACTIVE"
fi

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/adsmanager-timer.pid ]; then
  echo "Server [adsmanager-timer] pid file has been exists!";
  exit
fi


HEAP_MEMORY=256m
SERVER_JAR=`ls ../lib/adsmanager-timer-3.3.0.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms${HEAP_MEMORY} -Xmx${HEAP_MEMORY} -XX:+HeapDumpOnOutOfMemoryError -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/adsmanager-timer.pid