#!/bin/bash

if [ ! -f ~/run/adsmanager-timer.pid ]; then
  echo "Server [adsmanager-timer] doest not started!"
  exit
fi

pid=`cat ~/run/adsmanager-timer.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adsmanager-timer.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adsmanager-timer] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adsmanager-timer] cannot stop, Please check pid file 'adsmanager-timer.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adsmanager-timer] has been stoped!"
fi

rm -f ~/run/adsmanager-timer.pid