/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.annotation.around;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.dao.user.User;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * <h3>环绕日志记录</h3>
 * <p>可能存在问题，如果此方法失败，可能会影响到该方法注解的方法失败</p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */
@Aspect
@Component
public class LogAroundAspect {

    private static final Logger logger = Logger.getLogger(LogAroundAspect.class);

    public static final String SESSION_USER_NAME = "user";

    @Around("within(com.bxm..*) && @annotation(logAround)")
    public Object doAround(ProceedingJoinPoint point, LogAround logAround){

        long startTime = System.currentTimeMillis();//开始时间

        Object[] args = point.getArgs();//获取请求参数
        StringBuffer sb = new StringBuffer();
        if (ArrayUtils.isNotEmpty(args)) {
            for (Object arg : args) {
                sb.append(convent(arg));
            }
        }
        String params = sb.toString();//获取所有的参数

        //###################上面代码为方法执行前#####################
        Object result = new Object();
        try {
             result = point.proceed();//执行方法，获取返回参数
            logger.info("返回参数是：" + result);
        }catch (Throwable e){
            logger.error(e);
        }

        //###################下面代码为方法执行后#####################
        String user = logAround.user();
        if(StringUtils.isBlank(user)&&ArrayUtils.isNotEmpty(args)){
            user = getUser((HttpServletRequest) args[0]);
        }

        String operType = logAround.operType();
        long endTime = System.currentTimeMillis();//结束时间
        float excTime=(float)(endTime-startTime)/1000;
        logger.info("操作人："+user+"\n ，操作内容："+operType+"\n ,参数："+params+",\n 系统是："
                + logAround.keyName()+",\n 返回参数是：" + result+",\n 总耗时：" + excTime+"s");
        return  result;
    }

    private String convent(Object args){
        try {
            return JSONObject.toJSONString(args);
        }catch (Exception e){
            return "";
        }
    }

    /**
     * @description 获取用户信息
     * @author hcmony
     * @time 2017/12/29
     */
    public String  getUser(HttpServletRequest request){
        try {
            User user = (User) request.getSession().getAttribute(SESSION_USER_NAME);
            return user.getUsername();
        }catch (Exception e){
            logger.error("get user is null");
        }
        return "-";
    }
}
