/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.annotation.before;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.dao.user.User;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

/**
 * <h3>操作之前日志记录</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */
@Aspect
@Component
public class LogBeforeAspect {

    private static final Logger logger = Logger.getLogger(LogBeforeAspect.class);

    public static final String SESSION_USER_NAME = "user";

    @Before("@annotation(com.bxm.adsmanager.web.annotation.before.LogBefore)")
    public void doBefore(JoinPoint point){
        try {
            long startTime = System.currentTimeMillis();//开始时间
            Method method = getMethod(point);
            if(null == method){
                if(logger.isWarnEnabled()){
                    logger.warn("method is null");
                }
                return;
            }
            LogBefore logMessge = method.getAnnotation(LogBefore.class);

            Object[] args = point.getArgs();//获取请求参数
            StringBuffer sb = new StringBuffer();
            if (ArrayUtils.isNotEmpty(args)) {
                for (Object arg : args) {
                    sb.append(convent(arg));
                }
            }

            String params = sb.toString();//获取所有的参数
            String user = logMessge.user();
            if(StringUtils.isBlank(user)&&ArrayUtils.isNotEmpty(args)){
                user = getUser((HttpServletRequest) args[0]);
            }

            String operType = logMessge.operType();
            long endTime = System.currentTimeMillis();//结束时间
            float excTime=(float)(endTime-startTime)/1000;
            logger.info("操作人："+user+"，\n 操作内容："+operType+",\n 参数："+params+"," +
                    "\n 系统是：" + logMessge.keyName()+",\n 总耗时：" + excTime+"s");
        }catch (Exception e){
            logger.error("记录日志异常",e);
        }
    }

    private String convent(Object args){
        try {
            return JSONObject.toJSONString(args);
        }catch (Exception e){
            return "";
        }
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        } catch (NoSuchMethodException e) {
            return null;
        }
    }

    /**
     * @description 获取用户信息
     * @author hcmony
     * @time 2017/12/29
     */
    private String  getUser(HttpServletRequest request){
        try {
            User user = (User) request.getSession().getAttribute(SESSION_USER_NAME);
            return user.getUsername();
        }catch (Exception e){
            logger.error("get user is null");
        }
       return "-";
    }
}