/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adapi;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adapi.facade.AdPositionMaterialService;
import com.bxm.adapi.model.dto.AdPositionMaterialDto;
import com.bxm.adapi.model.dto.AdPositionMaterialEditDto;
import com.bxm.adapi.model.ro.AdPositionMaterialRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;

/**
 * @ClassName AdPositionMaterialController.java
 * @Description 功能描述：
 * @author leon 2018年3月22日 上午11:21:29
 * @CopyRight 杭州微财网络科技有限公司
 */
@RefreshScope
@RestController
@RequestMapping("/adapi/adPositionMaterial")
public class AdPositionMaterialController {

    @Autowired
    private AdPositionMaterialService adPositionMaterialService;

    /**
     * @Description 方法描述： 新增
     * @author leon 2017年10月23日 下午4:17:41
     * @CopyRight 杭州微财网络科技有限公司
     * @param AdPositionAdPositionMaterialEditDto
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<Boolean> add(AdPositionMaterialEditDto AdPositionMaterialEditDto) throws ValidateException,
                                                                                         Exception {
        return adPositionMaterialService.add(AdPositionMaterialEditDto);
    }

    /**
     * @Description 方法描述：修改状态
     * @author leon 2018年3月29日 下午3:48:59
     * @CopyRight 杭州微财网络科技有限公司
     * @param id
     * @param status
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> updateStatus(@RequestParam(value = "id", required = true) Long id,
                                             @RequestParam(value = "status", required = true) Integer status) throws ValidateException,
                                                                                                              Exception {
        return adPositionMaterialService.updateStatus(id, status);
    }

    /**
     * @Description 方法描述： 修改
     * @author leon 2017年10月23日 下午4:17:54
     * @CopyRight 杭州微财网络科技有限公司
     * @param AdPositionMaterialEditDto
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/update", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> update(AdPositionMaterialEditDto AdPositionMaterialEditDto) throws ValidateException,
                                                                                            Exception {

        return adPositionMaterialService.update(AdPositionMaterialEditDto);
    }

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param AdPositionMaterialDto
     * @return
     */
    @RequestMapping(value = "/getList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<AdPositionMaterialRo>> getList(AdPositionMaterialDto AdPositionMaterialDto) {

        return adPositionMaterialService.getList(AdPositionMaterialDto);

    }

}
