/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adapi;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adapi.facade.MaterialService;
import com.bxm.adapi.model.dto.MaterialDto;
import com.bxm.adapi.model.dto.MaterialEditDto;
import com.bxm.adapi.model.ro.MaterialRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;

import io.swagger.annotations.Api;

/**
 * @ClassName MaterialController.java
 * @Description 功能描述：素材库相关接口
 * @author leon 2018年3月22日 上午11:21:29
 * @CopyRight 杭州微财网络科技有限公司
 */
@EnableAutoConfiguration
@RefreshScope
@RestController
@RequestMapping("/adapi/material")
@Api(description = "素材库相关接口")
public class MaterialController {

    @Autowired
    private MaterialService materialService;

    /**
     * @Description 方法描述： 新增
     * @author leon 2017年10月23日 下午4:17:41
     * @CopyRight 杭州微财网络科技有限公司
     * @param MaterialEditDto
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<Boolean> add(MaterialEditDto MaterialEditDto) throws ValidateException, Exception {
        return materialService.add(MaterialEditDto);
    }

    /**
     * @Description 方法描述： 批量逻辑删除
     * @author leon 2017年10月23日 下午4:17:47
     * @CopyRight 杭州微财网络科技有限公司
     * @param ids
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/delete", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> delete(@RequestParam(value = "ids", required = true) List<Long> ids) throws ValidateException,
                                                                                                     Exception {
        return materialService.delete(ids);
    }

    /**
     * @Description 方法描述： 修改
     * @author leon 2017年10月23日 下午4:17:54
     * @CopyRight 杭州微财网络科技有限公司
     * @param MaterialEditDto
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/update", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> update(MaterialEditDto MaterialEditDto) throws ValidateException, Exception {

        return materialService.update(MaterialEditDto);
    }

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param MaterialDto
     * @return
     */
    @RequestMapping(value = "/getList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<MaterialRo>> getList(MaterialDto MaterialDto) {

        return materialService.getList(MaterialDto);

    }

}
