/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adapi;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adapi.facade.MediaAdPositionService;
import com.bxm.adapi.model.dto.MediaAdPositionDto;
import com.bxm.adapi.model.ro.MediaAdPositionRo;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

import io.swagger.annotations.Api;

/**
 * @ClassName MediaAdPositionController.java
 * @Description 功能描述：
 * @author leon 2018年3月22日 上午11:21:29
 * @CopyRight 杭州微财网络科技有限公司
 */
@EnableAutoConfiguration
@RefreshScope
@RestController
@RequestMapping("/adapi/mediaAdPosition")
@Api(description = "媒体广告位相关接口")
public class MediaAdPositionController {

    @Autowired
    private MediaAdPositionService mediaAdPositionService;

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param MediaAdPositionDto
     * @return
     */
    @RequestMapping(value = "/getList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<MediaAdPositionRo>> getList(MediaAdPositionDto MediaAdPositionDto) {

        return mediaAdPositionService.getList(MediaAdPositionDto);

    }

}
