package com.bxm.adsmanager.web.controller.adflowpackage;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.AdFlowPackageDto;
import com.bxm.adsmanager.model.dto.AdFlowPackageSearchDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adflowpackage.AdFlowPackageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsmanager.web.controller.AdFlowPackageController.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:48:00
 * @modifier 拉拉
 * @updated 2018-03-01 11:48:00
 */
@RestController
@RequestMapping("/adFlowPackage")
public class AdFlowPackageController extends BaseController {

    private static final Logger  logger = Logger.getLogger(AdFlowPackageController.class);
    @Autowired
    private AdFlowPackageService adFlowPackageService;

    /**
     * @description 添加流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adFlowPackage/add", keyName = "添加流量包")
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           AdFlowPackageDto adFlowPackageDto) {
        try {
            // 参数校验
            if (BeanValidator.validateGroup(adFlowPackageDto, AdFlowPackageDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adFlowPackageDto,
                                                                              AdFlowPackageDto.Add.class).getMessage());
            }
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            adFlowPackageService.add(adFlowPackageDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (PushProdException p) {
            logger.error("添加广告券弹窗出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        } catch (Exception e) {
            logger.error("添加广告券弹窗出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        }

    }

    /**
     * @description 根据条件查找流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response,
                                           AdFlowPackageSearchDto adFlowPackageSearchDto) {
        try {
            ResultModel<Pagination> rs = new ResultModel<Pagination>();
            Pagination result = adFlowPackageService.findAll(adFlowPackageSearchDto);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("查找广告券列表出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("查找广告券列表出错");
        } catch (Exception e) {
            logger.error("查找广告券列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找广告券列表出错");
        }
    }

    /**
     * @description 根据id查找流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findById", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<AdFlowPackageVo> findById(HttpServletRequest request, HttpServletResponse response,
                                                 String flowPackageId, String ticketId,String type) {
        ResultModel<AdFlowPackageVo> rs = new ResultModel<AdFlowPackageVo>();
        try {
            AdFlowPackageVo result = adFlowPackageService.findById(flowPackageId, ticketId,type);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("根据条件查找流量包出错" + p.getMessage(), p);
            rs.setErrorDesc("根据条件查找流量包出错");
            return rs;
        } catch (Exception e) {
            logger.error("查找广告券列表出错" + e.getMessage(), e);
            rs.setErrorDesc("根据条件查找流量包出错");
            return rs;
        }
    }

    /**
     * @description 根据流量包查找入口id
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findAdPositionByFlowPackageId", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAdPositionByFlowPackageId(HttpServletRequest request,
                                                                 HttpServletResponse response,
                                                                 AdFlowPackageSearchDto adFlowPackageSearchDto) {
        ResultModel<Pagination> rs = new ResultModel<Pagination>();
        try {
            Pagination result = adFlowPackageService.findAdPositionByFlowPackageId(adFlowPackageSearchDto);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("根据流量包id查找入口名称出错" + p.getMessage(), p);
            rs.setErrorDesc("根据流量包id查找入口名称出错");
            return rs;
        } catch (Exception e) {
            logger.error("根据流量包id查找入口名称出错" + e.getMessage(), e);
            rs.setErrorDesc("根据条件查找流量包出错");
            return rs;
        }
    }

    /**
     * @description 修改流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adFlowPackage/update", keyName = "修改流量包")
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              AdFlowPackageDto adFlowPackageDto) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            adFlowPackageService.update(adFlowPackageDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (PushProdException p) {
            logger.error("添加广告券弹窗出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        } catch (Exception e) {
            logger.error("添加广告券弹窗出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        }

    }
    /**
     * @description 修改流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adFlowPackage/updateStatus", keyName = "修改流量包")
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST, produces = "application/json")
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response,
                              AdFlowPackageDto adFlowPackageDto) {
        try {
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            adFlowPackageService.updateStatus(adFlowPackageDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (PushProdException p) {
            logger.error("添加广告券弹窗出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        } catch (Exception e) {
            logger.error("添加广告券弹窗出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        }

    }
    /**
     * @description 查找所有流量包的创建人
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findAllPackageName", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<String>> findAllPackageName(HttpServletRequest request, HttpServletResponse response) {
        ResultModel<List<String>> rs = new ResultModel<List<String>>();
        try {
            List<String> result = adFlowPackageService.findAllPackageName();
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("查找流量包创建人姓名出错" + p.getMessage(), p);
            rs.setErrorDesc("查找流量包创建人姓名出错");
            return rs;
        } catch (Exception e) {
            logger.error("查找流量包创建人姓名出错" + e.getMessage(), e);
            rs.setErrorDesc("查找流量包创建人姓名出错");
            return rs;
        }
    }

    /**
     * @description 修改流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adFlowPackage/delete", keyName = "删除流量包")
    @RequestMapping(value = "/delete", method = RequestMethod.GET, produces = "application/json")
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, String id) {
        try {
            // 获取后台用户名
            adFlowPackageService.delete(id);
            return ResultModelFactory.SUCCESS(null);
        } catch (PushProdException p) {
            logger.error("添加广告券弹窗出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        } catch (Exception e) {
            logger.error("添加广告券弹窗出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }

    }

    /**
     * @description 根据id查找流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findPositionIdsById", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<String> findPositionIdsById(HttpServletRequest request, HttpServletResponse response,
                                                   String ids) {
        ResultModel<String> rs = new ResultModel<String>();
        try {
            String result = adFlowPackageService.findPositionIdsById(ids);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("根据条件查找流量包出错" + p.getMessage(), p);
            rs.setErrorDesc("根据条件查找流量包出错");
            return rs;
        } catch (Exception e) {
            logger.error("查找广告券列表出错" + e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
    }

}
