package com.bxm.adsmanager.web.controller.adflowpackage;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowPackageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsmanager.web.controller.AdFlowPackageController.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:48:00
 * @modifier 拉拉
 * @updated 2018-03-01 11:48:00
 */
@RestController
@RequestMapping("/adTicketFlowPackageConf")
public class AdTicketFlowPackageConfController extends BaseController {

    private static final Logger        logger = Logger.getLogger(AdTicketFlowPackageConfController.class);
    @Autowired
    private AdTicketFlowPackageService adTicketFlowPackageService;

    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adTicketFlowPackageConf/add", keyName = "添加流量包")
    @RequestMapping(value = "/add", method = RequestMethod.GET, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           AdTicketFlowPackageDto adTicketFlowPackageDto) {
        try {
            // 参数校验
            if (BeanValidator.validateGroup(adTicketFlowPackageDto, AdTicketFlowPackageDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketFlowPackageDto,
                                                                              AdTicketFlowPackageDto.Add.class).getMessage());
            }
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            adTicketFlowPackageService.add(adTicketFlowPackageDto, userName,null);
            return ResultModelFactory.SUCCESS(true);
        } catch (PushProdException p) {
            logger.error("添加广告券弹窗出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        } catch (Exception e) {
            logger.error("添加广告券弹窗出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }

    }

    /**
     * @description 根据条件查找流量包
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<AdFlowPackageVo>> findAll(HttpServletRequest request, HttpServletResponse response,
                                                      String ticketId,String type) {
        ResultModel<List<AdFlowPackageVo>> rs = new ResultModel<List<AdFlowPackageVo>>();
        try {

            List<AdFlowPackageVo> result = adTicketFlowPackageService.findAll(ticketId,type);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("查找广告券流量包关联列表出错" + p.getMessage(), p);
            rs.setErrorDesc("根据条件查找广告券流量包关联列表出错");
            return rs;
        } catch (Exception e) {
            logger.error("查找广告券流量包关联列表出错" + e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
    }
    // 还差3个接口
    // 一个已经保存然后返回入口的接口
    // 还有一个删除空的流量包的接口（指没和广告券关联）

}
