package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.utils.BeanValidator;import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UploadImg;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-12-07 16:04:00
 * @Description 广告素材
 */
@RestController
@RequestMapping("/adAssets")
public class AdAssetsController extends BaseController {

	private static final Logger logger = Logger.getLogger(AdAssetsController.class);

	@Autowired
	private AdTicketAssetsService adTicketAssetsService;
	@Autowired
	private UploadImg uploadImg;

	/**
	 * @description 添加广告素材
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/add",keyName="广告")
	@RequestMapping(value = "/add", method = RequestMethod.POST)
	public ResultModel addAssets(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets)  {

		ResultModel rs = new ResultModel();
		try {
			if(adAssets ==null){
				return ResultModelFactory.FAIL400("参数不可以为空");
			}

			rs = checkParam(rs,adAssets);
			if(!rs.isSuccessed()){
				return rs;
			}

			adAssets.setCreateUser(getUser(request,response).getUsername());
			Object id = adTicketAssetsService.add(adAssets);
			rs.setReturnValue(id);
		}catch (Exception e){
			logger.error("添加广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加广告素材出错");
		}
		return  rs;
	}

	/**
     * @description 添加广告素材
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    @LogBefore(operType="/adAssets/addNew",keyName="广告")
    @RequestMapping(value = "/addNew", method = RequestMethod.POST)
    public ResultModel addNew(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets,Long ticketId)  {

        ResultModel rs = new ResultModel();
        try {
            if(adAssets ==null){
                return ResultModelFactory.FAIL400("参数不可以为空");
            }

            rs = checkParam(rs,adAssets);
            if(!rs.isSuccessed()){
                return rs;
            }

            adAssets.setCreateUser(getUser(request,response).getUsername());
             adTicketAssetsService.addNew(adAssets,ticketId);
            rs.setReturnValue(true);
        }catch (Exception e){
            logger.error("添加广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告素材出错");
        }
        return  rs;
    }
	/**
	 * @description 添加广告素材图片 换个权限校验方式
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/uploadImg",keyName="广告")
	@RequestMapping(value = "/uploadImg", method = RequestMethod.POST)
	@Deprecated
	public ResultModel uploadImg(HttpServletRequest request, HttpServletResponse response) {

		ResultModel rs = new ResultModel();
		try {
			//上传图片，使用的方法，地址和老系统一致
			JSONArray urlString = (JSONArray)uploadImg.uploadImg(response, request, "certificate", logger);
			if(urlString!=null){
				JSONObject urlJson =  urlString.getJSONObject(0);
				String url = (String)urlJson.get("url");
				rs.setReturnValue(url);
			}
		}catch (Exception e){
			logger.error("添加添加广告素材图片出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加添加广告素材图片出错");
		}
		return  rs;
	}

	/**
	 * @description 根据素材ids查找所有广告素材,这里没有做分页处理
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel findAllAssets(String ids) {

		ResultModel rs = new ResultModel();
		try {
			List<AdAssets> list = adTicketAssetsService.findAll(ids);
			if(list!=null){
				rs.setSuccessed(true);
			}
			rs.setReturnValue(list);
		}catch (Exception e){
			logger.error("根据素材ids查找所有广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("根据素材ids查找所有广告素材出错");
		}
		return  rs;
	}

	/**
	 * @description 根据广告券id查找广告素材,这里没有做分页处理
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAllAssetsById", method = RequestMethod.GET)
	public ResultModel findAllAssetsById(Long id) {

		ResultModel rs = new ResultModel();

		if(id==null){
			return ResultModelFactory.FAIL400("id不能为空");
		}

		try {
			List<AdAssets> list = adTicketAssetsService.findAllAssetsById(id);
			if(list!=null){
				rs.setSuccessed(true);
			}
			rs.setReturnValue(list);
		}catch (Exception e){
			logger.error("根据广告券id查找广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
		}
		return  rs;
	}



	/**
	 * @description 更新广告素材
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/update",keyName="广告")
	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public ResultModel updateAllAssets(HttpServletRequest request, HttpServletResponse response,AdAssets adAssets) {

		ResultModel rs = new ResultModel();
		try {
			if(adAssets ==null|| adAssets.getId()==null){
				return ResultModelFactory.FAIL400("id不能为空");
			}

			rs = checkParam(rs,adAssets);
			if(!rs.isSuccessed()){
				return rs;
			}

			adAssets.setModifyUser(getUser(request,response).getUsername());

			Object result = adTicketAssetsService.update(adAssets);
			if(result!=null){
				rs.setSuccessed(true);
			}
		}catch (Exception e){
			logger.error("更新广告素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告素材出错");
		}
		return  rs;
	}


	/**
	 * @description 删除广告券素材
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adAssets/delete",keyName="广告")
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	public ResultModel deleteAssets(HttpServletRequest request, HttpServletResponse response,
									 @RequestParam(required = true, name = "ids") String ids) {

		ResultModel rs = new ResultModel();
		try {
			String userName = getUser(request,response).getUsername();
			//直接删除了
			Object result = adTicketAssetsService.delete(ids);
			if(result!=null){
				rs.setReturnValue(result);
			}
		}catch (Exception e){
			logger.error("删除广告券素材出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("删除广告券素材出错");
		}
		return  rs;
	}


	/**
	 * @description 素材参数校验
	 * @author hcmony
	 * @time 2017/12/29
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param rs
	 * @param adAssets
	 * @return com.bxm.util.dto.ResultModel
	 */
	public <T> ResultModel checkParam(ResultModel<T> rs ,AdAssets adAssets){

		if(AdAssets.VARS_NO==adAssets.getVars()&& StringUtil.isBlank(adAssets.getName())){
			return ResultModelFactory.FAIL400("不显示省市的时候name不能为空");
		}

		if(AdAssets.VARS_NO!=adAssets.getVars()&& StringUtil.isBlank(adAssets.getContent())){
			return ResultModelFactory.FAIL400("显示省市的时候素材内容不能为空");
		}

		//参数校验
		if (BeanValidator.validateGroup(adAssets, AdAssets.Add.class) != null) {
			return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adAssets, AdAssets.Add.class).getMessage());
		}
		return  rs;
	}
	
	/**
     * @description 根据广告券id查找广告素材,这里没有做分页处理
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    @RequestMapping(value = "/findAllAssetsListByParams", method = RequestMethod.GET,produces = "application/json")
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response,
                                                             AdAssetsDto adAssetsDto) {

        ResultModel<Pagination> rs = new ResultModel<Pagination>();

        if(adAssetsDto.getTicketId()==null){
            return ResultModelFactory.FAIL400("礼券id不能为空");
        }
        try {
            Pagination list = adTicketAssetsService.findAllAssetsListByParams(adAssetsDto);
            if(list!=null){
                rs.setSuccessed(true);
            }
            rs.setReturnValue(list);
        }catch (Exception e){
            logger.error("根据广告券id查找广告素材出错"+e.getMessage(), e);
            return ResultModelFactory.FAIL500("根据广告券id查找广告素材出错");
        }
        return  rs;
    }

}
