package com.bxm.adsmanager.web.controller.adkeeper;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.adsmanager.model.dto.AdpositionDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <h3>广告位查询</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/12 15:00
 */
@RequestMapping("/adProsition")
@RestController
public class AdPrositionController {

	private static final Logger logger = Logger.getLogger(AdPrositionController.class);

	@Autowired
	private AdPositionService adPositionService;


	/**
	 * @description 广告位查询
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response,
										   AdpositionDto adpositionDto) {

		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {
			Pagination result = adPositionService.findAll(adpositionDto);
			if(result!=null){
				rs.setReturnValue(result);
			}
		}catch (Exception e){
			logger.error("广告位查询错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("广告位查询错误");
		}
		return  rs;
	}

	/**
	 * @description 根据广告券id查找广告位
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findByAdTicketId", method = RequestMethod.GET)
	public ResultModel<Pagination> findByAdTicketId(HttpServletRequest request, HttpServletResponse response,
													AdpositionDto adpositionDto) {

		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {

			if(adpositionDto==null||null==adpositionDto.getAdTicketId()){
				return ResultModelFactory.FAIL400("adTicketId is null");
			}

			Pagination result = adPositionService.findByAdTicketId(adpositionDto);
			if(result!=null){
				rs.setReturnValue(result);
			}
		}catch (Exception e){
			logger.error("根据广告券id查找广告位错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("根据广告券id查找广告位错误");
		}
		return  rs;
	}

	/**
	 * @description 根据广告位id查找广告位
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findByIdsStr", method = RequestMethod.POST,produces="application/json")
	public ResultModel<Pagination> findByIdsStr(HttpServletRequest request, HttpServletResponse response,
													AdpositionDto adpositionDto) {

		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {

			Pagination result = adPositionService.findByIdsStr(adpositionDto);
			if(result!=null){
				rs.setReturnValue(result);
			}
		}catch (Exception e){
			logger.error("根据广告位id查找广告位错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("根据广告位id查找广告位错误");
		}
		return  rs;
	}

}
