package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dao.adkeeper.*;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.*;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-12-07 16:04:00
 * @Description
 */
@RestController
@RequestMapping("/adTicket")
public class AdTicketController extends BaseController{

	private static final Logger logger = Logger.getLogger(AdTicketController.class);

	@Autowired
	private AdTicketService adTicketService;
	@Autowired
	private AdShopIntegration adShopIntegration;

	/**
	 * @description 添加广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/add",keyName="广告")
	@RequestMapping(value = "/add", method = RequestMethod.POST,produces="application/json")
	public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketDto  adTicketDto){
		try {
			//参数校验
			if (BeanValidator.validateGroup(adTicketDto, AdTicketDto.Add.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketDto, AdTicketDto.Add.class).getMessage());
			}

			String userName = getUser(request,response).getUsername();
			Long ticketId= adTicketService.add(adTicketDto,userName);
			return ResultModelFactory.SUCCESS(ticketId);
		}catch (PushProdException p){
			logger.error("添加广告券出错"+p.getMessage(), p);
			return ResultModelFactory.FAIL500("推送数据到前端异常");
		}catch (Exception e){
			logger.error("添加广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加广告券出错");
		}
	}

	/**
	 * @description 获取广告主列表
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "queryAdvertiser", method = RequestMethod.GET)
	public ResultModel<com.bxm.adsmanager.integration.advertiser.model.Pagination> queryAdvertiser(HttpServletRequest request, HttpServletResponse response){
		ResultModel<com.bxm.adsmanager.integration.advertiser.model.Pagination> rs = new ResultModel<>();
		try {
			Map<String, Object> param = new HashMap<String, Object>();
			Integer pageNum = 1;
			Integer pageSize = 20;
			String pageNumStr = request.getParameter("pageNum");
			if(StringUtils.isNotBlank(pageNumStr)){
				pageNum=Integer.parseInt(pageNumStr);
			}
			String pageSizeStr = request.getParameter("pageSize");
			if(StringUtils.isNotBlank(pageSizeStr)){
				pageSize=Integer.parseInt(pageSizeStr);
			}

			param.put("pageNum", pageNum);
			param.put("pageSize",pageSize);
			if(StringUtils.isNotBlank(request.getParameter("id"))){
				param.put("id", request.getParameter("id"));
			}
			if(StringUtils.isNotBlank(request.getParameter("keywords"))){
				param.put("keywords", request.getParameter("keywords"));
			}
			com.bxm.adsmanager.integration.advertiser.model.Pagination pageBean = adShopIntegration.getAdvertiserPage(param);
			rs.setReturnValue(pageBean);
		} catch (Exception e) {
			logger.error("获取广告主列表出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("获取广告主列表出错");
		}
		return rs;
	}


	/**
	 * @description 更新广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/update",keyName="广告")
	@RequestMapping(value = "/update", method = RequestMethod.POST,produces="application/json")
	public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdTicketDto  adTicketDto) {

		ResultModel rs = new ResultModel();
		if(adTicketDto==null||adTicketDto.getId()==null){
			return ResultModelFactory.FAIL400("广告券id不能为空");
		}
		try {
			//参数校验
			if (BeanValidator.validateGroup(adTicketDto, AdTicketDto.Update.class) != null) {
				return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketDto, AdTicketDto.Update.class).getMessage());
			}

			String userName = getUser(request,response).getUsername();
			Long result = adTicketService.update(adTicketDto,userName);
			rs.setReturnValue(result);
		}catch (Exception e){
			logger.error("更新广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告券出错");
		}
		return  rs;
	}

	/**
	 * @description 查找广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/find", method = RequestMethod.GET)
	public ResultModel<AdTicketVo> find(Long id) {

		ResultModel<AdTicketVo> rs = new ResultModel<AdTicketVo>();
		if(id==null){
			return ResultModelFactory.FAIL400("广告券id不能为空");
		}
		try {
			AdTicketVo result = adTicketService.findById(id);
			rs.setReturnValue(result);
		}catch (ValidateException v){
			logger.error(v.getMessage(), v);
			return ResultModelFactory.FAIL400(v.getMessage());
		}catch (Exception e){
			logger.error("查找广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找广告券出错");
		}
		return  rs;
	}

	/**
     * @description 查找广告券
     * @author hcmony
     * @time 2017/12/8
     * @CopyRight 杭州微财网络科技有限公司
     * @return java.lang.Object
     */
    @RequestMapping(value = "/findBykeywords", method = RequestMethod.GET)
    public ResultModel<List<AdTicketVo>> findBykeywords(HttpServletRequest request, HttpServletResponse response,AdTicketSearchDto condition) {

        ResultModel<List<AdTicketVo>> rs = new ResultModel<List<AdTicketVo>>();
        try {
            List<AdTicketVo> result = adTicketService.findBykeywords(condition);
            rs.setReturnValue(result);
        }catch (ValidateException v){
            logger.error(v.getMessage(), v);
             rs.setErrorDesc(v.getMessage());
        }catch (Exception e){
            logger.error("查找广告券出错"+e.getMessage(), e);
            rs.setErrorDesc(e.getMessage());
        }
        return  rs;
    }

	/**
	 * @description 删除广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/delete",keyName="广告")
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	public ResultModel delete(HttpServletRequest request, HttpServletResponse response,Long id) {

		ResultModel rs = new ResultModel();
		if(id==null){
			return ResultModelFactory.FAIL400("广告券id不能为空");
		}
		try {
			String userName = getUser(request,response).getUsername();
			Integer result = adTicketService.delete(id,userName);
			rs.setReturnValue(result);
		}catch (Exception e){
			logger.error("更新广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告券出错");
		}
		return  rs;
	}


	/**
	 * @description 查找所有广告券
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<Pagination> findAll(AdTicketSearchDto searchDto) {

		ResultModel rs = new ResultModel();

		try {
			Pagination result = adTicketService.findAll(searchDto);
			rs.setReturnValue(result);
		}catch (Exception e){
			logger.error("查找所有广告券出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("查找所有广告券出错");
		}
		return  rs;
	}


	/**
	 * @description 更新广告券状态
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/adTicket/updateStatus",keyName="广告")
	@RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true, name = "status") Short status) {

		//状态。0 停止、1 正常、2 暂停、-1 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setModifyUser(getUser(request,response).getUsername());
			Object result = adTicketService.updateStatus(adTicket);
			rs.setReturnValue(result);
		}catch (ValidateException v){
			return ResultModelFactory.FAIL400(v.getMessage());
		}catch (Exception e){
			logger.error("更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("更新广告券状态出错");
		}
		return  rs;
	}

}
