/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.controller.adposition;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.app.facade.AppEntranceFacadeService;
import com.bxm.app.model.dto.AuditAdPositionDto;
import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;

/**
 * @ClassName AdPositionAuditController.java
 * @Description 功能描述： 广告位审核
 * @author leon 2018年4月2日 下午4:26:18
 * @CopyRight 杭州微财网络科技有限公司
 */
@RestController
@EnableAutoConfiguration
@RefreshScope
@RequestMapping(value = "/adPositionAudit")
public class AdPositionAuditController {

    @Autowired
    private AppEntranceFacadeService appEntranceFacadeService;

    /**
     * @Description 方法描述：查询列表（审核列表）
     * @author leon 2018年4月2日 下午3:11:57
     * @CopyRight 杭州微财网络科技有限公司
     * @param positionId
     * @param keywords
     * @param state
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/getAuditList", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<AppEntranceAdRo>> getAuditList(@RequestParam(value = "pageNum", required = true) Integer pageNum,
                                                               @RequestParam(value = "pageSize", required = true) Integer pageSize,
                                                               @RequestParam(value = "positionId", required = false) String positionId,
                                                               @RequestParam(value = "keyword", required = false) String keywords,
                                                               @RequestParam(value = "state", required = false) Integer state) throws ValidateException,
                                                                                                                               Exception {

        return appEntranceFacadeService.getAuditList(pageNum, pageSize, positionId, keywords, state);
    }

    /**
     * @Description 方法描述：审核广告位信息
     * @author leon 2018年4月2日 下午3:56:34
     * @CopyRight 杭州微财网络科技有限公司
     * @param auditAdPositionDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/auditAdPosition", method = RequestMethod.PUT, produces = "application/json")
    public ResultModel<Boolean> auditAdPosition(AuditAdPositionDto auditAdPositionDto) throws ValidateException,
                                                                                       Exception {

        return appEntranceFacadeService.auditAdPosition(auditAdPositionDto);
    }
}
