package com.bxm.adsmanager.web.controller.adprofit;


import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.bxm.adsmanager.model.dao.adprofit.LocalCache;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketProfitSearchDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo;
import com.bxm.adsmanager.model.vo.AdTicketIncomeVo;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

/**  
* @Title: AdIncomeTicketController 
* @Description:  广告收益录入相关接口
* @author xavier  
* @date 2018年3月6日  
*/  
@RequestMapping("/adTicketProfit")
@RestController
public class AdIncomeTicketController extends BaseController{
	
	private static final Logger logger = Logger.getLogger(AdIncomeTicketController.class);
	@Autowired
	private AdIncomeTicketService adIncomeTicketService;
	
	/**  
	 * @Title: findAll  
	 * @Description:  查询礼券消耗信息，时间维度
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<List<AdTicketIncomeVo>> findAll(HttpServletRequest request, 
			HttpServletResponse response,AdTicketProfitSearchDto search){
		ResultModel<List<AdTicketIncomeVo>> rs = new ResultModel<List<AdTicketIncomeVo>>();
		try {
			User user = getUser(request, response);	
			//如果用户只为AE角色CODE 则加上限制
			if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
					user.getRoleCodes().contains(RoleEnum.AE.getCode())) {
				search.setUserName(user.getUsername());			
			}
			List<AdTicketIncomeVo> lists = adIncomeTicketService.getTicketIncomeList(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			logger.error("礼券收益列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("礼券收益列表查询错误");
		}
		return rs;
	}
	
	/**  
	 * @Title: findDetailBydatetime  
	 * @Description:  按时间查询礼券下号信息详情
	 * @author xavier  
	 * @date 2018年3月6日
	 */  
	@RequestMapping(value = "/findDetail", method = RequestMethod.GET)
	public ResultModel<List<AdTicketIncomeDetailVo>> findDetailBydatetime(HttpServletRequest request, 
			HttpServletResponse response,AdTicketProfitSearchDto search){
		ResultModel<List<AdTicketIncomeDetailVo>> rs = new ResultModel<List<AdTicketIncomeDetailVo>>();
		try {
			User user = getUser(request, response);	
			//如果用户只为AE角色CODE 则加上限制
			if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 &&
					user.getRoleCodes().contains(RoleEnum.AE.getCode())) {
				search.setUserName(user.getUsername());			
			}
			List<AdTicketIncomeDetailVo> lists = adIncomeTicketService.getTicketIncomeDeatil(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			logger.error("礼券收益详情列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("礼券收益详情列表查询错误");
		}
		return rs;
	}


	/**
	 * @description
	 * @author hcmony
	 * @time 2018/3/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo>>
	 */
	@LogBefore(keyName = "广告",operType = "/adTicketProfit/update")
	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id") int id,
							  @RequestParam(required = true, name = "number") int number){
		try {
			User user = getUser(request, response);
			int result = adIncomeTicketService.update(id,number,user.getUsername());
			return ResultModelFactory.SUCCESS(result);
		} catch (Exception e) {
			logger.error("礼券收益编辑错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**
	 * @description
	 * @author hcmony
	 * @time 2018/3/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.util.dto.ResultModel<java.util.List<com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo>>
	 */
	@LogBefore(keyName = "广告",operType = "/adTicketProfit/entering")
	@RequestMapping(value = "/entering", method = RequestMethod.POST)
	public ResultModel entering(HttpServletRequest request, HttpServletResponse response,
								@RequestParam(required = true, name = "ids")String ids,
								@RequestParam(required = true, name = "datetime") String datetime){

		try {
			synchronized (this){
				Boolean flag = LocalCache.map.get(ids);
				if(flag!=null&&flag){
					logger.info("数据在录入中，请稍候再试,ids:"+ids);
					return ResultModelFactory.FAIL400("数据在录入中，请稍候再试");
				}
				LocalCache.map.put(ids,true);
			}

			User user = getUser(request, response);

			adIncomeTicketService.entering( ids,datetime,user.getUsername());
			LocalCache.map.remove(ids);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			LocalCache.map.remove(ids);
			logger.error("礼券收益收益录入错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}
}
