package com.bxm.adsmanager.web.controller.adprofit;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.model.dao.adprofit.LocalCache;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ExcelUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dto.AdMediaPositionProfitSearchDto;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitAllVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
import com.bxm.util.dto.ResultModel;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**  
* @Title: AdProfitMediaPositionController 
* @Description: 媒体广告位收益信息 
* @author xavier  
* @date 2018年3月10日  
*/  
@RequestMapping("/adProfitMediaPosition")
@RestController
public class AdProfitMediaPositionController extends BaseController{
	
	private static final Logger logger 		= Logger.getLogger(AdProfitMediaPositionController.class);
	private static final int DEFULT_ONE = 1;
	@Autowired
	private AdProfitMediaPositionService adProfitMediaPositionService;
	
	/**  
	 * @Title: findAll  
	 * @Description:  开发者收益信息
	 * @author xavier  
	 * @date 2018年3月10日
	 */  
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<List<AdProfitAllVo>> findAll(HttpServletRequest request, 
			HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<List<AdProfitAllVo>> rs = new ResultModel<List<AdProfitAllVo>>();
		try {
			List<AdProfitAllVo> lists = adProfitMediaPositionService.findAll(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			logger.error("开发者总收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("开发者总收益查询错误");
		}
		return rs;
	} 

	/**  
	 * @Title: findMediaProfit  
	 * @Description:  查询媒体收益列表分页
	 * @author xavier  
	 * @date 2018年3月10日
	 */  
	@RequestMapping(value = "/findMediaProfit", method = RequestMethod.GET)
	public ResultModel<Pagination> findMediaProfit(HttpServletRequest request, 
			HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {
			Pagination lists = adProfitMediaPositionService.findMediaProfit(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			logger.error("开发者收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("开发者收益查询错误");
		}
		return rs;
	} 

	/**  
	 * @Title: findPositionProfit  
	 * @Description:  查询广告位收益列表分页
	 * @author xavier  
	 * @date 2018年3月10日
	 */  
	@RequestMapping(value = "/findPositionProfit", method = RequestMethod.GET)
	public ResultModel<Pagination> findPositionProfit(HttpServletRequest request, 
			HttpServletResponse response,AdMediaPositionProfitSearchDto search){
		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		try {
			Pagination lists = adProfitMediaPositionService.findPositionProfit(search);
			rs.setReturnValue(lists);
		} catch (Exception e) {
			logger.error("广告位收益查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("广告位收益查询错误");
		}
		return rs;
	}

	/**
	 * @description  导入收益Excel表格 //todo 此接口为了配合前端的参数校验，迁到excel包下面
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/importProfit")
	@RequestMapping(value = "/importProfit", method = RequestMethod.POST)
	@Deprecated
	public ResultModel<Pagination> importProfitExcel(HttpServletRequest request,
											HttpServletResponse response){
		try {
			MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
			Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
			User user = getUser(request, response);
			for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
				MultipartFile file = entity.getValue();// 获取上传文件对象
				// 获得文件名称
				String originalFilename = file.getOriginalFilename();
				if (originalFilename.indexOf("媒体收益")!=-1) {
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("实际收益", "profitActual");
					fieldMap.put("备注", "remark");
					List<AdProfitMediaDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"媒体收益", AdProfitMediaDto.class, fieldMap, DEFULT_ONE);
							//ExcelUtil.importExcel(file,DEFULT_ONE,DEFULT_ONE,AdProfitMediaVo.class);
					adProfitMediaPositionService.importAdProfitMediaExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}else if(originalFilename.indexOf("广告位收益")!=-1){
					LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
					fieldMap.put("ID", "id");
					fieldMap.put("日期", "datetime");
					fieldMap.put("广告位ID", "positionId");
					fieldMap.put("媒体ID", "appId");
					fieldMap.put("预估收益", "profitPredict");
					fieldMap.put("扣量金额", "profitDeduct");
					fieldMap.put("备注", "remark");
					List<AdProfitPositionDto> results = ExcelUtils.excelToList(file.getInputStream(),
							"广告位收益", AdProfitPositionDto.class, fieldMap, DEFULT_ONE);
					adProfitMediaPositionService.importAdProfitPositionExcel(user,results);
					return ResultModelFactory.SUCCESS();
				}else {
					return ResultModelFactory.FAIL500("导入失败(表格名称不识别)");
				}
			}
		} catch (ProfitException pe) {
			return ResultModelFactory.FAIL500(pe.getMessage());
		}catch (Exception e) {
			logger.error("导入媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("导入媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 下载媒体收益Excel表格  //todo 此接口为了配合前端的参数校验，迁到excel包下面
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/downLoadMedia")
	@RequestMapping(value = "/downLoadMedia", method = RequestMethod.GET)
	@Deprecated
	public ResultModel downLoadMediaExcel(HttpServletRequest request,
														HttpServletResponse response,
													   @RequestParam(required = true, name = "datetime") String datetime){
		try {
			List<AdProfitMediaVo> list = adProfitMediaPositionService.downLoadMedia(datetime);
			//导出操作
			ExcelUtil.exportExcel(list, null, "媒体收益", AdProfitMediaVo.class, "媒体收益"+datetime+".xls", response);
		} catch (Exception e) {
			logger.error("下载媒体收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("下载媒体收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 下载广告位收益Excel表格 //todo 此接口为了配合前端的参数校验，迁到excel包下面
	 * @author hcmony
	 * @time 2018/3/14
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel<com.bxm.adsmanager.model.vo.Pagination>
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/downLoadPosition")
	@RequestMapping(value = "/downLoadPosition", method = RequestMethod.GET)
	@Deprecated
	public ResultModel downLoadPositionExcel(HttpServletRequest request,
										  HttpServletResponse response,
										  @RequestParam(required = true, name = "datetime") String datetime,
											@RequestParam(required = false, name = "appId") String appId){
		try {
			List<AdProfitPositionVo> list = adProfitMediaPositionService.downLoadPosition( datetime,appId);
			//导出操作
			ExcelUtil.exportExcel(list, null, "广告位收益", AdProfitPositionVo.class, "广告位收益"+datetime+".xls", response);
		} catch (Exception e) {
			logger.error("下载广告位收益Excel表格错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("下载广告位收益Excel表格错误");
		}
		return ResultModelFactory.SUCCESS();
	}

	/**
	 * @description 导入
	 * @author hcmony
	 * @time 2018/3/16
	 * @param request
	 * @param response
	 * @param datetime
	 * @return com.bxm.util.dto.ResultModel
	 */
	@LogBefore(keyName = "广告",operType = "/adProfitMediaPosition/entering")
	@RequestMapping(value = "/entering", method = RequestMethod.POST)
	public ResultModel entering(HttpServletRequest request, HttpServletResponse response,
								@RequestParam(required = true, name = "datetime") String datetime){

		try {
			synchronized (this){
				Boolean flag = LocalCache.map.get(datetime);
				if(flag!=null&&flag){
					logger.info("数据在录入中，请稍候再试,datetime:"+datetime);
					return ResultModelFactory.FAIL400("数据在录入中，请稍候再试");
				}
				LocalCache.map.put(datetime,true);
			}
			User user = getUser(request, response);
			adProfitMediaPositionService.entering(user,datetime);
			LocalCache.map.remove(datetime);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			LocalCache.map.remove(datetime);
			logger.error("礼券收益收益录入错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}


}
