package com.bxm.adsmanager.web.controller.adticketpopup;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.AdTicketNameDto;
import com.bxm.adsmanager.model.dto.AdTicketPopupDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adticketpopup.AdTicketPopupService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsmanager.web.controller.adticketpopup.AdPopup.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 11:48:00
 * @modifier 拉拉
 * @updated 2018-03-01 11:48:00
 */
@RestController
@RequestMapping("/adTicketPopup")
public class AdTicketPopupController extends BaseController {

    private static final Logger  logger = Logger.getLogger(AdTicketPopupController.class);
    @Autowired
    private AdTicketPopupService adTicketPopupService;

    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adTicketPopup/add", keyName = "礼券弹窗")
    @RequestMapping(value = "/add", method = RequestMethod.POST, produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           AdTicketPopupDto adTicketPopupDto) {
        try {
            // 参数校验
            if (BeanValidator.validateGroup(adTicketPopupDto, AdTicketPopupDto.Add.class) != null) {
                return ResultModelFactory.FAIL400(BeanValidator.validateGroup(adTicketPopupDto,
                                                                              AdTicketPopupDto.Add.class).getMessage());
            }
            // 获取后台用户名
            String userName = getUser(request, response).getUsername();
            adTicketPopupService.add(adTicketPopupDto, userName);
            return ResultModelFactory.SUCCESS(null);
        } catch (PushProdException p) {
            logger.error("添加广告券弹窗出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        } catch (Exception e) {
            logger.error("添加广告券弹窗出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("添加广告券弹窗出错");
        }

    }

    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param adTicketPopupDto
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adTicketPopup/findAll", keyName = "礼券弹窗")
    @RequestMapping(value = "/findAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response,
                                           AdTicketPopupDto adTicketPopupDto) {
        try {
            ResultModel<Pagination> rs = new ResultModel<Pagination>();
            Pagination result = adTicketPopupService.findAll(adTicketPopupDto);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("查找广告券列表出错" + p.getMessage(), p);
            return ResultModelFactory.FAIL500("查找广告券列表出错");
        } catch (Exception e) {
            logger.error("查找广告券列表出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找广告券列表出错");
        }
    }

    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param positionId
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adTicketPopup/findByPositionId", keyName = "单个入口的礼券弹窗")
    @RequestMapping(value = "/findByPositionId", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<AdTicketNameDto>> findByPositionId(HttpServletRequest request, HttpServletResponse response,
                                                               String positionId) {
        ResultModel<List<AdTicketNameDto>> rs = new ResultModel<List<AdTicketNameDto>>();
        try {

            List<AdTicketNameDto> result = adTicketPopupService.findByPositionId(positionId);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("查找单个入口的弹窗券列表出错" + p.getMessage(), p);
            rs.setErrorDesc("查找单个入口的弹窗券列表出错");
            return rs;
        } catch (Exception e) {
            logger.error("查找单个入口的弹窗券列表出错" + e.getMessage(), e);
            rs.setErrorDesc("查找单个入口的弹窗券列表出错");
            return rs;
        }
    }

    /**
     * @description
     * @author 拉拉
     * @time 2018/3/1
     * @CopyRight 杭州微财科技有限公司
     * @param request
     * @param response
     * @param positionId
     * @return com.bxm.util.dto.ResultModel
     */
    @LogBefore(operType = "/adTicketPopup/findTicketPoputReport", keyName = "礼券报表")
    @RequestMapping(value = "/findTicketPoputReport", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<AdTicketNameDto>> findTicketPoputReport(HttpServletRequest request,
                                                                    HttpServletResponse response, String positionId) {
        ResultModel<List<AdTicketNameDto>> rs = new ResultModel<List<AdTicketNameDto>>();
        try {

            List<AdTicketNameDto> result = adTicketPopupService.findByPositionId(positionId);
            if (result != null) {
                rs.setReturnValue(result);
            }
            return rs;
        } catch (PushProdException p) {
            logger.error("查找单个入口的弹窗券列表出错" + p.getMessage(), p);
            rs.setErrorDesc("查找单个入口的弹窗券列表出错");
            return rs;
        } catch (Exception e) {
            logger.error("查找单个入口的弹窗券列表出错" + e.getMessage(), e);
            rs.setErrorDesc("查找单个入口的弹窗券列表出错");
            return rs;
        }
    }
}
