package com.bxm.adsmanager.web.controller.common;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <h3>字典控制器</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/14 11:24
 */
@RestController
@RequestMapping("/common")
public class DictionariesController {

	private static final Logger logger = Logger.getLogger(DictionariesController.class);

	@Autowired
	private DictionariesService dictionariesService;

	/**
	 * @description 根据字典id查找所有字典
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<Pagination> findAll(String typegroupid) {

		ResultModel rs = new ResultModel();

		try {
			if(typegroupid==null){
				rs.setSuccessed(false);
				rs.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
				rs.setErrorDesc("typegroupid不可以为空");
				return rs;
			}
			List<Dictionaries>  list = dictionariesService.findAll(typegroupid);

			rs.setReturnValue(list);
		}catch (Exception e){
			logger.error("根据字典id查找所有字典出错"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
			rs.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
		}
		return  rs;
	}
}
