package com.bxm.adsmanager.web.controller.common;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dto.InfoMediaMsgDto;
import com.bxm.adsmanager.model.dto.InfoPositionMsgDto;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.service.common.MediaPositionService;
import com.bxm.util.dto.ResultModel;

/**  
* @Title: MediaPositionController 
* @Description: 获取媒体和广告位的信息 
* @author xavier  
* @date 2018年3月14日  
*/  
@RequestMapping("/mediaPosition")
@RestController
public class MediaPositionController {
	
	private static final Logger logger = Logger.getLogger(MediaPositionController.class);
	
	@Autowired
	private MediaPositionService mediaPositionService;
	
	/**  
	 * @Title: findAll  
	 * @Description:  通过APPKEY 和  关键字查询媒体信息列表
	 * @author xavier  
	 * @date 2018年3月14日
	 */  
	@RequestMapping(value = "/findMediaAll", method = RequestMethod.GET)
	public ResultModel<List<InfoMediaMsgDto>> findMediaAll(CommonSearchDto search) { 
		ResultModel<List<InfoMediaMsgDto>> rs = new ResultModel<List<InfoMediaMsgDto>>();
		try {
			rs.setReturnValue(mediaPositionService.findMediaAll(search));
		} catch (Exception e) {
			logger.error("媒体信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("媒体信息列表查询错误");
		}
		return rs;
	}
	
	/**  
	 * @Title: findAll  
	 * @Description:  通过APPKEY 和关键字查询广告位信息列表
	 * @author xavier  
	 * @date 2018年3月14日
	 */  
	@RequestMapping(value = "/findPositionAll", method = RequestMethod.GET)
	public ResultModel<List<InfoPositionMsgDto>> findPositionAll(CommonSearchDto search) { 
		ResultModel<List<InfoPositionMsgDto>> rs = new ResultModel<List<InfoPositionMsgDto>>();
		try {
			if (StringUtils.isEmpty(search.getAppKey())) {
				rs.setSuccessed(false);
				rs.setErrorDesc("请选择需要查询的广告位");
				return rs;
			}
			rs.setReturnValue(mediaPositionService.findPositionAll(search));
		} catch (Exception e) {
			logger.error("广告位信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("广告位信息列表查询错误");
		}
		return rs;
	}

}
