package com.bxm.adsmanager.web.controller.copydata;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.adsmanager.service.copydata.CopyDataService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <h3>老系统同步数据到新系统</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/01/23 19:50
 */
@RestController
@RequestMapping("/copydata")
public class CopyDataController {

	private static final Logger logger = Logger.getLogger(CopyDataController.class);

	@Autowired
	private CopyDataService copyDataService;

	/**
	 * 渠道黑白名单
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/app", method = RequestMethod.POST)
	public ResultModel app(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");

		try {
			boolean result = copyDataService.copyApp(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("复制渠道黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**
	 * 时间黑白名单
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/date", method = RequestMethod.POST)
	public ResultModel date(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");

		try {
			boolean result = copyDataService.copyDate(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("复制时间段黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**
	 * 素材关联
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/image", method = RequestMethod.POST)
	public ResultModel image(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");

		try {
			boolean result = copyDataService.copyImage(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("复制时间段黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**
	 * 地域黑白名单
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/ip", method = RequestMethod.POST)
	public ResultModel ip(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");

		try {
			boolean result = copyDataService.copyIp(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("复制时间段黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}


	/**
	 * 广告券剩余内容，如： 不支持设备  权重系数  价格变化关联表
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/certificateOther", method = RequestMethod.POST)
	public ResultModel certificateOther(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");
		try {
			boolean result = copyDataService.copyCertificateOther(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("复制时间段黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**
	 * 个推规则分数 以及一票否决同步
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/getui", method = RequestMethod.POST)
	public ResultModel getui(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");
		try {
			boolean result = copyDataService.copyGetui(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("复制时间段黑白名单出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}


	/**
	 * 推送数据到前端
	 * @param request
	 * @param response
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/pushProd", method = RequestMethod.POST)
	public ResultModel pushProd(HttpServletRequest request, HttpServletResponse response,Long id) {

		response.setHeader("Access-Control-Allow-Origin", "*");
		try {
			boolean result = copyDataService.pushProd(id);
			return ResultModelFactory.SUCCESS(result);
		}catch (Exception e){
			logger.error("推送数据到前端出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}
}
