package com.bxm.adsmanager.web.controller.exception;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */



import com.bxm.adsmanager.integration.exception.*;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;



/**
 * <h3>所有异常统一处理类</h3>
 * <p></p>
 * @author hcmony
 * @since V1.0.0, 2017/12/21 14:46
 */
@ControllerAdvice
@RestController
public class AllExceptionController {

	@ExceptionHandler(value=ValidateException.class)
	public ResultModel vlidateException(ValidateException v) {
		return ResultModelFactory.FAIL400(v.getMessage());
	}

	@ExceptionHandler(value= PullProdException.class)
	public ResultModel pullProdException(PullProdException v) {
		return exchenge(v);
	}

	@ExceptionHandler(value= PushProdException.class)
	public ResultModel pushProdException(PushProdException v) {
		return exchenge(v);
	}
	@ExceptionHandler(value= PullAdshopException.class)
	public ResultModel pushProdException(PullAdshopException v) {
		return exchenge(v);
	}
	@ExceptionHandler(value= PushGeTuiException.class)
	public ResultModel pushGeTuiException(PushGeTuiException v) {
		return exchenge(v);
	}

	@ExceptionHandler(value=PushAdmanagerException.class)
	public ResultModel pushAdmanagerException(PushAdmanagerException v) {
		return exchenge(v);
	}

	@ExceptionHandler(value=Exception.class)
	public ResultModel exception(PushAdmanagerException v) {
		return exchenge(v);
	}

	/**
	 * @description
	 * @author hcmony
	 * @time 2018/1/10
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param e
	 * @return com.bxm.util.dto.ResultModel
	 */
	public ResultModel exchenge(Exception e){
		return ResultModelFactory.FAIL500(e.getMessage());
	}
}
