package com.bxm.adsmanager.web.controller.exclude;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UploadImg;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @FileName package com.bxm.adsmanager.web.controller.adkeeper.AdTicketController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-12-07 16:04:00
 * @Description 参数不受拦截器控制
 */
@RestController
@RequestMapping("/exclude")
public class ExcludeAssetsController extends ExcludeBaseController {

	private static final Logger logger = Logger.getLogger(com.bxm.adsmanager.web.controller.adkeeper.AdAssetsController.class);

	@Autowired
	private UploadImg uploadImg;


	/**
	 * @description 添加广告素材图片
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(operType="/exclude/uploadImg",keyName="广告")
	@RequestMapping(value = "/uploadImg", method = RequestMethod.POST)
	public ResultModel uploadImg(HttpServletRequest request, HttpServletResponse response,
								 @RequestParam(required = true, name = "token") String token) {

		ResultModel rs = new ResultModel();
		try {
			boolean result = auth(request,response,token);
			if(!result){
				return ResultModelFactory.FAIL400("用户没有权限");
			}
			//上传图片，使用的方法，地址和老系统一致
			JSONArray urlString = (JSONArray)uploadImg.uploadImg(response, request, "certificate", logger);
			if(urlString!=null){
				JSONObject urlJson =  urlString.getJSONObject(0);
				String url = (String)urlJson.get("url");
				rs.setReturnValue(url);
			}
		}catch (Exception e){
			logger.error("添加添加广告素材图片出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL500("添加添加广告素材图片出错");
		}
		return  rs;
	}
}
