package com.bxm.adsmanager.web.controller.exclude;

import com.bxm.adsmanager.integration.datapark.model.ActivityCount;
import com.bxm.adsmanager.integration.datapark.model.DataParkContens;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.datapark.service.DataparkActivityPullerIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.report.*;
import com.bxm.adsmanager.service.datapark.DataparkActivityService;
import com.bxm.adsmanager.service.datapark.DataparkTicketService;
import com.bxm.adsmanager.service.report.IAppReportService;
import com.bxm.adsmanager.service.report.ITicketReportService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.ExcludeBaseController;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/04/17 10:01
 */
@RestController
@RequestMapping("/exclude")
public class ExcludeReortController extends ExcludeBaseController {

	private static final Logger logger 		= Logger.getLogger(ExcludeReortController.class);

	@Autowired
	private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;

	@Autowired
	private DataparkActivityService dataparkActivityService;

	@Autowired
	private IAppReportService appReportService;

	@Autowired
	private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;

	@Autowired
	private DataparkTicketService dataparkTicketService;

	@Autowired
	private ITicketReportService ticketReportService;

	/*
     * 活动报表按日导出
     * @author zhangkai
     * @date 2018/2/28 15:03
     * @param
     * @return
     */
	@RequestMapping(value = "/activityReportByDateExport", method = RequestMethod.GET)
	public void activityReportByDateExport(HttpServletRequest request,HttpServletResponse response,
										   @RequestParam(name = DataParkContens.START_TIME) String startTime,
										   @RequestParam(name = DataParkContens.END_TIME) String endTime,
										   @RequestParam(name = DataParkContens.ACTIVITY_ID) Long activityId,
										   @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
										   @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType
										   ){
		//User user = getUser(request,response);
		List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportByDate(startTime,endTime,activityId,sortName,sortType);
		dataparkActivityService.activityReportByDateExport(activityCounts,response);
	}

	/*
     * 导出活动报表开发者维度
     * @author zhangkai
     * @date 2018/2/28 11:53
     * @param
     * @return
     */
	@RequestMapping(value = "/activityReportAppExport", method = RequestMethod.GET)
	public void activityReportAppExport(HttpServletRequest request,HttpServletResponse response,
										@RequestParam(required = true,  name = DataParkContens.DATETIME) String datetime,
										@RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
										@RequestParam(required = false, name = DataParkContens.ACTIVITY_ID) Long activityId){
		//User user = getUser(request,response);
		String json = dataparkActivityService.getAppKeys(keywords);
		List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportAppExport(datetime,json,activityId);
		dataparkActivityService.activityReportAppExport(activityCounts,response);

	}


	/*
	* 导出活动报表子链接维度
	* @author zhangkai
	* @date 2018/2/28 14:38
	* @param
	* @return
	*/
	@RequestMapping(value = "/activityReportAppBusinessExport", method = RequestMethod.GET)
	public void activityReportAppBusinessExport(HttpServletRequest request,HttpServletResponse response,
												@RequestParam(required = true,  name = DataParkContens.DATETIME) String datetime,
												@RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
												@RequestParam(required = false, name = DataParkContens.ACTIVITY_ID) Long activityId,
												@RequestParam(required = false, name = DataParkContens.APP_KEY) String appKey){
		//User user = getUser(request,response);
		String json = dataparkActivityService.getBusiness(appKey,keywords);
		List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportAppBusinessExport(datetime,json,activityId,appKey);
		dataparkActivityService.activityReportAppBusinessExport(activityCounts,response);

	}

	/*
	* 活动报表子链接按日导出
	* @author zhangkai
	* @date 2018/2/28 15:22
	* @param
	* @return
	*/
	@RequestMapping(value = "/activityReportBusinessByDateExport", method = RequestMethod.GET)
	public void activityReportBusinessByDateExport(HttpServletRequest request,HttpServletResponse response,
													@RequestParam(name = DataParkContens.START_TIME) String startTime,
												   @RequestParam(name = DataParkContens.END_TIME) String endTime,
												   @RequestParam(name = DataParkContens.ACTIVITY_ID) Long activityId,
												   @RequestParam(name = DataParkContens.APP_KEY) String appKey,
												   @RequestParam(name = DataParkContens.BUSINESS) String business,
												   @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
												   @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType){

		//User user = getUser(request,response);
		List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime,endTime,activityId,appKey,business,sortName,sortType);
		dataparkActivityService.activityReportBusinessByDateExport(activityCounts,response);
	}

	/*
     * 导出活动报表
     * @author zhangkai
     * @date 2018/2/28 11:09
     * @param
     * @return
     */
	@RequestMapping(value = "/activityReportExport", method = RequestMethod.GET)
	public void activityReportExport(HttpServletRequest request,HttpServletResponse response,
									@RequestParam(required = true, name = DataParkContens.DATETIME) String datetime,
									 @RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
									 @RequestParam(required = false, name = DataParkContens.ACTIVITYTYPE) String activityType){
		//User user = getUser(request,response);
		String json = dataparkActivityService.getActivityIds(keywords,activityType);
		List<ActivityCount> activityCounts = dataparkActivityPullerIntegration.activityReportExport(datetime,json);
		dataparkActivityService.activityReportExport(activityCounts,response);
	}


	/**
	 * 导出开发者子链接
	 *
	 * @param response
	 * @param datetime
	 * @param keyword
	 * @param appKey
	 * @param sortName
	 * @param sortType
	 * @return
	 */
	@RequestMapping("/app/business/export")
	public void findAppBusinessCountExport(
			HttpServletRequest request,HttpServletResponse response,
			@RequestParam(name = ReportConstant.DATETIME) String datetime,
			@RequestParam(name = ReportConstant.KEYWORD,required = false) String keyword,
			@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
			@RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.OPEN_PV_VO) String sortName,
			@RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
		//声明结果集
		List<AppBusinessVo> appBusinessCounts = null;
		try {
			//User user = getUser(request,response);
			//服务层调用
			appBusinessCounts = appReportService.findAppBusinessCountExport(datetime, keyword, appKey, sortName, sortType);
		} catch (Exception e) {
			//异常情况
			logger.error("导出开发者日报按子链接失败" + e.getMessage(), e);
		}
		//导出操作
		ExcelUtil.exportExcel(appBusinessCounts, null, null, AppBusinessVo.class, "开发者日报按子链接.xls", response);
	}

	/**
	 * 导出开发者子链接按活动
	 * @param datetime
	 * @param appKey
	 * @param business
	 * @param keyword
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/app/business/activityExport")
	public void AppBusinessActivityExport(
			HttpServletRequest request,HttpServletResponse response,
			@RequestParam(name = ReportConstant.DATETIME , required = false) String datetime,
			@RequestParam(name = ReportConstant.APPKEY_VO , required = false) String appKey,
			@RequestParam(name = ReportConstant.BUSINESS, required = false) String business,
			@RequestParam(name = ReportConstant.KEYWORD , required = false) String keyword) throws IOException {
		//User user = getUser(request,response);
		List<ActivityVo> list =  appReportService.appBusinessActivityExport(datetime,appKey,business,keyword);
		ExcelUtil.exportExcel(list, null, null, ActivityVo.class, "开发者子渠道按活动.xls", response);

	}

	/**
	 * 导出开发者子链接按日
	 * @param startTime
	 * @param endTime
	 * @param appKey
	 * @param sortName
	 * @param sortType
	 * @return
	 */
	@RequestMapping("/app/business/date/export")
	public void findAppBusinessCountByDateExport(
			HttpServletRequest request,HttpServletResponse response,
			@RequestParam(name = ReportConstant.START_TIME) String startTime,
			@RequestParam(name = ReportConstant.END_TIME) String endTime,
			@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
			@RequestParam(name = ReportConstant.BUSINESS) String business,
			@RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
			@RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
		//声明结果集
		List<AppBusinessByDateVo> appCounts= null;
		try {
			//User user = getUser(request,response);
			//服务层调用
			appCounts = appReportService.findAppBusinessCountByDate(appKey,business, startTime, endTime, sortName, sortType);
		} catch (Exception e) {
			//异常情况
			logger.error("导出开发者子链接按日失败"+e.getMessage(), e);
		}
		//导出操作
		ExcelUtil.exportExcel(appCounts, null, null, AppBusinessByDateVo.class, "开发者子链接日报.xls", response);
	}

	/**
	 * 导出查询开发者子链接广告券
	 * @param response
	 * @param datetime
	 * @param appKey
	 * @param business
	 * @param keyword
	 * @return
	 */
	@RequestMapping("/app/business/ticket/export")
	public void findAppBusinessTicketExport(
			HttpServletRequest request,HttpServletResponse response,
			@RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
			@RequestParam(name = ReportConstant.DATETIME) String datetime,
			@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
			@RequestParam(name = ReportConstant.BUSINESS) String business,
			@RequestParam(name = ReportConstant.JSON, required = false) String keyword) {
		//声明结果集
		List<AppBusinessTicketVo> appBusinessTickets = null;
		try {
			//User user = getUser(request,response);
			//服务层调用
			appBusinessTickets = appReportService.findAppBusinessTicketExport(datetime, appKey, business, scene,keyword);
		} catch (Exception e) {
			//异常情况
			logger.error("导出开发者子链接广告券失败"+e.getMessage(), e);
		}
		//返回结果
		ExcelUtil.exportExcel(appBusinessTickets, null, null, AppBusinessTicketVo.class, "开发者子链接广告券.xls", response);
	}

	/**
	 * 导出开发者日报按日
	 * @param startTime
	 * @param endTime
	 * @param appKey
	 * @param sortName
	 * @param sortType
	 * @return
	 */
	@RequestMapping("/app/date/export")
	public void findAppCountByDateExport(
			HttpServletRequest request,HttpServletResponse response,
			@RequestParam(name = ReportConstant.START_TIME) String startTime,
			@RequestParam(name = ReportConstant.END_TIME) String endTime,
			@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
			@RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
			@RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
		//声明结果集
		List<AppByDateVo> appCounts= null;
		try {
			//User user = getUser(request,response);
			//服务层调用
			appCounts = appReportService.findAppCountDate(appKey, startTime, endTime, sortName, sortType);
		} catch (Exception e) {
			//异常情况
			logger.error("导出开发者日报按日失败"+e.getMessage(), e);
		}
		//导出操作
		ExcelUtil.exportExcel(appCounts, null, null, AppByDateVo.class, "开发者日报按日.xls", response);
	}

	/**
	 * 导出开发者日报
	 *
	 * @param response
	 * @param datetime
	 * @param keyword
	 * @param sortName
	 * @param sortType
	 */
	@RequestMapping(value = "/app/export", method = RequestMethod.GET)
	public void getAppCountExport(HttpServletRequest request, HttpServletResponse response,
								  @RequestParam(name = ReportConstant.DATETIME) String datetime,
								  @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
								  @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
								  @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
		//获取当前用户
		User user = getUser(request, response);
		//声明并实例化结果集
		List<AppCountVo> appCounts = null;
		try {
			//调用服务层
			appCounts = appReportService.getAppCountExport(datetime, keyword,user, sortName, sortType);
		} catch (Exception e) {
			logger.error("导出开发者日报失败" + e.getMessage(), e);
		}
		//导出操作
		ExcelUtil.exportExcel(appCounts, null, null, AppCountVo.class, "开发者日报.xls", response);
	}

	/**
	 * 导出开发者下面的广告券,其中，只传appkey,差的是开发者按广告券维度
	 * 若appkey和Business都传，则查询的是子链接按馆告券维度
	 * 其中json，是广告券ID 集合JSON，List<Long>
	 * @param response
	 * @param datetime
	 * @param appKey
	 * @param scene
	 * @param keyword
	 */
	@RequestMapping("/app/ticket/export")
	public void appTicketExport(HttpServletRequest request, HttpServletResponse response,
								@RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
								@RequestParam(name = ReportConstant.DATETIME) String datetime,
								@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
								@RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword) {
		//声明结果集
		List<AppTicketVo> appTicketCounts = null;
		try {
			//User user = getUser(request,response);
			//服务层调用
			appTicketCounts = appReportService.findAppTicketCount(datetime, appKey, scene,keyword);

		} catch (Exception e) {
			//异常情况
			logger.error("导出开发者下面的广告券失败"+e.getMessage(), e);
		}
		//导出操作
		ExcelUtil.exportExcel(appTicketCounts, null, null, AppTicketVo.class, "开发者广告券日报.xls", response);
	}

	/**
	 * 导出开发者下面的广告券
	 * @param response
	 * @param startTime
	 * @param endTime
	 * @param appKey
	 * @param certificateid
	 * @param sortName
	 * @param sortType
	 */
	@RequestMapping("/app/ticket/date/export")
	public void findAppTicketDateExport(
			HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = ReportConstant.START_TIME) String startTime,
			@RequestParam(name = ReportConstant.END_TIME) String endTime,
			@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
			@RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
			@RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
			@RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
		//声明结果集
		List<AppTicketDateVo> appTicketCountDates = null;
		try {
			//User user = getUser(request,response);
			//服务层调用
			appTicketCountDates = appReportService.findAppTicketCountDate(startTime, endTime, appKey, certificateid, sortName, sortType);
		} catch (Exception e) {
			//异常情况
			logger.error("导出开发者下面的广告券按日失败"+e.getMessage(), e);
		}
		//导出操作
		ExcelUtil.exportExcel(appTicketCountDates, null, null, AppTicketDateVo.class, "开发者广告券按日.xls", response);
	}

	@RequestMapping("/ticket/date/export")
	public void findTicketCountDateExport(
			HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = ReportConstant.START_TIME) String startTime,
			@RequestParam(name = ReportConstant.END_TIME) String endTime,
			@RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
			@RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
			@RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
		List<TicketDateVo> ticketCountDates = null;
		try {
			//User user = getUser(request,response);
			ticketCountDates = ticketReportService.findTicketCountDate(startTime, endTime, certificateid, sortName, sortType);
		} catch (Exception e) {
			logger.error("导出广告券按日失败：" + e.getMessage(), e);
		}
		ExcelUtil.exportExcel(ticketCountDates, null, null, TicketDateVo.class, "广告券按日.xls", response);
	}

	@RequestMapping("/ticket/app/export")
	public void findTicketAppCountExport(
			HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = ReportConstant.DATETIME) String datetime,
			@RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
			@RequestParam(name = ReportConstant.JSON, required = false) String keyword) {
		List<TicketAppVo> ticketAppCounts = null;
		try {
			//User user = getUser(request,response);
			ticketAppCounts = ticketReportService.findTicketAppCountExport(datetime, certificateid, keyword);
		} catch (Exception e) {
			logger.error("查询广告券维度失败：" + e.getMessage(), e);
		}
		ExcelUtil.exportExcel(ticketAppCounts, null, null, TicketAppVo.class, "广告券开发者.xls", response);
	}

	@RequestMapping("/ticket/app/business/export")
	public void findTicketAppBusinessCountExport(
			HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = ReportConstant.DATETIME) String datetime,
			@RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
			@RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
			@RequestParam(name = ReportConstant.JSON, required = false) String keyword) {
		List<TicketAppBusinessVo> ticketAppCounts = null;
		try {
			//User user = getUser(request,response);
			ticketAppCounts = ticketReportService.findTicketAppBusinessCountExport(datetime,certificateid,appKey, keyword);
		} catch (Exception e) {
			logger.error("导出广告券开发者子链接维度失败：" + e.getMessage(), e);
		}
		ExcelUtil.exportExcel(ticketAppCounts, null, null, TicketAppBusinessVo.class, "广告券开发者子链接.xls", response);
	}

	/**
	 * 导出广告券日报小时维度子链接
	 * @param certificateid
	 * @param appKey
	 * @param business
	 * @param datetime
	 * @param sHour
	 * @param eHour
	 * @param response
	 */
	@RequestMapping(value = "/ticketReportBusinessHourExport", method = RequestMethod.GET)
	public void ticketReportBusinessHourExport(HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
											   @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
											   @RequestParam(name = DataParkContens.BUSINESS, required = false) String business,
											   @RequestParam(name = DataParkContens.DATETIME) String datetime,
											   @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
											   @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour) {
		//User user = getUser(request,response);
		List<TicketCountCommon> list = dataparkTicketPullerIntegration.ticketHoursExport(datetime,certificateid,appKey,business,sHour,eHour);
		dataparkTicketService.ticketDataExport(list,response);
	}

	/**
	 * 导出广告券日报小时维度开发者
	 * @param certificateid
	 * @param appKey
	 * @param datetime
	 * @param sHour
	 * @param eHour
	 * @param response
	 */
	@RequestMapping(value = "/ticketReportAppHourExport", method = RequestMethod.GET)
	public void ticketReportAppHourExport(HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
										  @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
										  @RequestParam(name = DataParkContens.DATETIME) String datetime,
										  @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
										  @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour) {
		//User user = getUser(request,response);
		List<TicketCountCommon> list = dataparkTicketPullerIntegration.ticketHoursExport(datetime,certificateid,appKey,null,sHour,eHour);
		dataparkTicketService.ticketDataExport(list,response);
	}


	/**
	 * 导出广告券日报小时维度
	 * @param certificateid
	 * @param datetime
	 * @param sHour
	 * @param eHour
	 * @param response
	 */
	@RequestMapping(value = "/ticketReportHourExport", method = RequestMethod.GET)
	public void ticketReportHourExport(HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
									   @RequestParam(name = DataParkContens.DATETIME) String datetime,
									   @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
									   @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour) {
		//User user = getUser(request,response);
		List<TicketCountCommon> list = dataparkTicketPullerIntegration.ticketHoursExport(datetime,certificateid,null,null,sHour,eHour);
		dataparkTicketService.ticketDataExport(list,response);
	}

	@RequestMapping("/ticket/export")
	public void findTicketCount(
			HttpServletRequest request, HttpServletResponse response,
			@RequestParam(name = ReportConstant.DATETIME) String datetime,
			@RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
			@RequestParam(name = ReportConstant.JSON, required = false) String keyword) {
		List<TicketCountVo> ticketCounts = null;
		try {
			//User user = getUser(request,response);
			ticketCounts = ticketReportService.findTicketCountExport(datetime,scene, keyword);
		} catch (Exception e) {
			logger.error("导出广告券维度失败：" + e.getMessage(), e);
		}
		ExcelUtil.exportExcel(ticketCounts, null, null, TicketCountVo.class, "广告券.xls", response);

	}

	/**
	 * 导出开发者日报根据不同角色看到不同数据（bd只能看到自己的媒体）
	 * @param startTime
	 * @param startTime
	 * @param keyword
	 * @return
	 */
	@RequestMapping(value="/app/appCountSumByDateExport",method = RequestMethod.GET)
	public ResultModel findAppCountSumByDate(HttpServletRequest request,
											 HttpServletResponse response,
											 @RequestParam(name = ReportConstant.START_TIME) String startTime,
											 @RequestParam(name = ReportConstant.END_TIME) String endTime,
											 @RequestParam(name = ReportConstant.KEYWORD , required = false) String keyword

	){
		//获取当前用户
		User user = getUser(request, response);
		//声明并实例化结果集
		ResultModel<List<AppCountVo>> resultModel = new ResultModel<>();
		try {
			//调用服务层
			resultModel.setReturnValue(appReportService.appCountSumByDateExport(startTime,endTime,keyword,user));
		} catch (Exception e) {
			logger.error("导出开发者日报失败" + e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return resultModel;
	}


}
