/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.controller.facade;


import com.bxm.adsmanager.integration.adsprod.service.ProdAdvertiserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketProfitForCpa;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

/**
 * <h3>供广告调用</h3>
 * <p>//todo 这里后面可能做参数验证，权限拦截过滤 以及是否要移到 facade  项目中</p>
 * @author hcmony
 * @since V1.0.0, 2018/02/28 19:11
 */
@RestController
@RequestMapping("/advertiser")
public class AdvertiserTicketController {

	private static final Logger logger = Logger.getLogger(AdvertiserTicketController.class);

	@Autowired
	private AdTicketService adTicketService;
	@Autowired
	private ProdAdvertiserIntegration prodAdvertiserIntegration;
	@Autowired
	private ProdPusherIntegration prodPusherIntegration;

	/**
	 * @description advertiser更新广告券状态
	 * @author hcmony
	 * @time 2018/2/28
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param id
	 * @param status
	 * @return com.bxm.util.dto.ResultModel
	 */

	@LogBefore(user = "advertiser",operType="/advertiser/updateAdTicket",keyName="广告")
	@RequestMapping(value = "/updateAdTicket", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true,name = "status") Short status) {
		//状态。1 正常、2 暂停、3 停止、99 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setModifyUser("广告主更新");
			logger.info("advertiser请求更新广告券状态:id="+id+",status="+status);
			Integer result = adTicketService.advertiserUpdateStatus(adTicket);
			rs.setReturnValue(result);
		}catch (Exception e){
			logger.error("advertiser更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

	/**
	 * @description advertiser更新广告券日预算
	 * @author hcmony
	 * @time 2018/2/28
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @param id
	 * @param dailyBudget
	 * @return com.bxm.util.dto.ResultModel
	 */

	@LogBefore(user = "advertiser",operType="/advertiser/updateDailyBudget",keyName="广告")
	@RequestMapping(value = "/updateDailyBudget", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true,name = "dailyBudget") Double dailyBudget) {
		//状态。1 正常、2 暂停、3 停止、99 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			logger.info("advertiser请求更新广告券日预算:id="+id+",dailyBudget="+dailyBudget);
			Integer result = adTicketService.updateDailyBudget(id,dailyBudget);
			rs.setReturnValue(result);
		}catch (Exception e){
			logger.error("advertiser请求更新广告券日预算"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

}
