package com.bxm.adsmanager.web.controller.facade;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.adsmanager.integration.adsprod.service.ProdAdvertiserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketProfitForCpa;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

/**
 * <h3>供adsprod调用更新广告券状态</h3>
 * <p>//todo 这里后面可能做参数验证，权限拦截过滤 以及是否要移到 facade  项目中</p>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@RestController
@RequestMapping("/adsmanager")
public class FacadeTicketController {

	private static final Logger logger = Logger.getLogger(FacadeTicketController.class);

	@Autowired
	private AdTicketService adTicketService;
	@Autowired
	private ProdAdvertiserIntegration prodAdvertiserIntegration;
	@Autowired
	private ProdPusherIntegration prodPusherIntegration;

	/**
	 * @description adsprod更新广告券状态
	 * @author hcmony
	 * @time 2017/12/8
	 * @CopyRight 杭州微财网络科技有限公司
	 * @return java.lang.Object
	 */
	@LogBefore(user = "adsprod",operType="/adsmanager/updateAdTicket",keyName="广告")
	@RequestMapping(value = "/updateAdTicket", method = RequestMethod.POST)
	public ResultModel update(HttpServletRequest request, HttpServletResponse response,
							  @RequestParam(required = true, name = "id" ) Long id,
							  @RequestParam(required = true, name = "reason") Integer reason,
							  @RequestParam(required = true,name = "status") Short status) {

		//状态。0 停止、1 正常、2 暂停、-1 已删除
		//暂停原因。1- 超出预算、2- 余额不足;3-未到投放日期;4-投放结束
		response.setHeader("Access-Control-Allow-Origin", "*");

		ResultModel rs = new ResultModel();
		try {
			AdTicket adTicket = new AdTicket();
			adTicket.setId(id);
			adTicket.setStatus(status);
			adTicket.setPauseReason(reason);
			adTicket.setModifyUser("前端系统判断");
			logger.info("adsprod请求更新广告券状态:id="+id+",status="+status+",reason="+reason);
			Integer result = adTicketService.facadeUpdateStatus(adTicket);
			rs.setReturnValue(result);
		}catch (Exception e){
			logger.error("adsprod更新广告券状态出错"+e.getMessage(), e);
			return ResultModelFactory.FAIL();
		}
		return  rs;
	}

	@RequestMapping("/plusAdvertiserBalance")
	public ResultModel<Long> plusAdvertiserBalance(@RequestParam("id") Long id, @RequestParam("value") Long value) {
		try {
			Long balance = prodAdvertiserIntegration.incrementBalance(BigInteger.valueOf(id), value);
			return ResultModelFactory.SUCCESS(balance);
		} catch (Exception e) {
			if (logger.isErrorEnabled()) {
				logger.error("pushAdvertiserBalance:", e);
			}
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	@RequestMapping(value = "/pushCpaProfitData", method = RequestMethod.POST)
	public ResultModel<?> pushCpaProfitData(@RequestBody List<TicketProfitForCpa> data) {
		try {
			String rst = prodPusherIntegration.pushToProd(ProdServiceNameEnum.TICKET_PROFIT_FOR_CPA.getServiceName(), Maps.newHashMap(), JsonHelper.convert2bytes(data));
			if (StringUtils.isBlank(rst)) {
				return ResultModelFactory.FAIL500("Push failed!");
			}
			return ResultModelFactory.SUCCESS();
		}catch (Exception e){
			return ResultModelFactory.FAIL500("Push failed!");
		}
	}

	@RequestMapping(value = "/pushPosition/{id}", method = RequestMethod.POST)
	public ResultModel<?> pushPosition(@PathVariable("id") String positionId,
									   @RequestBody Position position) {
		try {
			Map<String, Object> parameter = Maps.newHashMap();
			parameter.put(ProdServiceNameEnum.POSITION.getParameters(), positionId);
			String rst = prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION.getServiceName(), parameter, JsonHelper.convert2bytes(position));
			if (StringUtils.isBlank(rst)) {
				return ResultModelFactory.FAIL500("Push failed!");
			}
			return ResultModelFactory.SUCCESS();
		}catch (Exception e){
			return ResultModelFactory.FAIL500("Push failed!");
		}
	}
}
