package com.bxm.adsmanager.web.controller.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.service.datapark.DataparkIncomeService;
import com.bxm.util.StringUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * 开发者收益
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.facade.IncomeController.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-03-08 21:14:00
 * @modifier 阿导
 * @updated 2018-03-08 21:14:00
 */
@RestController
public class IncomeController {
    private static final Logger logger = Logger.getLogger(IncomeController.class);
    @Autowired
    private DataparkIncomeService dataparkIncomeService;


    /**
     * 处理开发者收益
     *
     * @author 阿导
     * @time 2018/3/8
     * @CopyRight 杭州微财科技有限公司
     * @param datetime
     * @return void
     */
    @RequestMapping("/app/income/update")
    public void dealAppCash(@RequestParam(name = "datetime") String datetime){
        try {
            dataparkIncomeService.dealAppCash(datetime);
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        }
    }


    /**
     * 更新礼券收益
     *
     * @author 阿导
     * @time 2018/3/19
     * @CopyRight 杭州微财科技有限公司
     * @param datetime
     * @param certificateids
     * @return void
     */
    @RequestMapping("/ticket/income/update")
    public void dealAppCash(@RequestParam(name = "datetime") String datetime,@RequestParam(name = "certificateids") String certificateids){
        try {
            //参数校验
            if(StringUtil.isEmpty(certificateids)||StringUtil.isEmpty(datetime)){
                return;
            }
            dataparkIncomeService.dealTicketIncome(datetime, JSON.parseArray(certificateids,Long.class));
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        }
    }
}
