package com.bxm.adsmanager.web.controller.menu;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.model.dao.menu.AdMenu;
import com.bxm.adsmanager.model.dto.menu.AdMenuDto;
import com.bxm.adsmanager.model.vo.AdMenuVo;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketProfitSearchDto;
import com.bxm.adsmanager.service.menu.AdMenuRoleService;
import com.bxm.adsmanager.web.controller.adprofit.AdIncomeTicketController;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RequestMapping("/adMenu")
@RestController
public class AdMenuController extends BaseController{
	
	private static final Logger logger = Logger.getLogger(AdMenuController.class);
	
	@Autowired
	private AdMenuRoleService adMenuRoleService;

	/**  
	 * @Title: findMenuByCode  
	 * @Description:  通过Role查询菜单信息
	 * @author xavier  
	 * @date 2018年3月20日
	 */  
	@RequestMapping(value = "/findMenuByRole", method = RequestMethod.GET)
	public ResultModel<List<AdMenuDto>> findAll(HttpServletRequest request,
			HttpServletResponse response,AdTicketProfitSearchDto search){
		response.setHeader("Access-Control-Allow-Origin", "*");
		ResultModel<List<AdMenuDto>> rs = new ResultModel<List<AdMenuDto>>();
		try {
			User user = getUser(request, response);
			List<AdMenuVo> menus = adMenuRoleService.findMenuByRole(user.getRoleCodes());
			rs.setReturnValue(menuVo2Dto(menus));
		} catch (Exception e) {
			logger.error("查询角色菜单列表错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("查询角色菜单列表错误");
		}
		return rs;
	}

	private List<AdMenuDto> menuVo2Dto(List<AdMenuVo> menus) {
		List<AdMenuDto>result = new ArrayList<AdMenuDto>();
		for(AdMenuVo vo : menus){
			result.add(new AdMenuDto(vo));
		}
		return result;
	}
}
