/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.controller.report;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.adsmanager.integration.platform.service.PositionIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.report.AppBusinessByDateVo;
import com.bxm.adsmanager.model.vo.report.AppBusinessTicketVo;
import com.bxm.adsmanager.model.vo.report.AppBusinessVo;
import com.bxm.adsmanager.model.vo.report.AppByDateVo;
import com.bxm.adsmanager.model.vo.report.AppCountVo;
import com.bxm.adsmanager.model.vo.report.AppTicketDateVo;
import com.bxm.adsmanager.model.vo.report.AppTicketVo;
import com.bxm.adsmanager.service.report.IAppReportService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;

/**
 * 开发者报表，控制层
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.report.AppReportController.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:25:00
 * @modifier 阿导
 * @updated 2018-02-27 11:25:00
 */
@Controller
@RequestMapping("/report")
public class AppReportController extends BaseController{

    private static final Logger logger = LoggerFactory.getLogger(AppReportController.class);

    @Autowired
    private IAppReportService appReportService;

    /**
     * 分页查询开发者日报
     *
     * @param datetime
     * @param keyword
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/app/getAppCount", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel<Page<AppCountVo>> getAppCount(HttpServletRequest request, HttpServletResponse response,
    											     @RequestParam(name = ReportConstant.DATETIME) String datetime,
                                                     @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
                                                     @RequestParam(name = ReportConstant.PAGE_SIZE, required = false, defaultValue = ReportConstant.TEN_S) Integer pageSize,
                                                     @RequestParam(name = ReportConstant.PAGE_NUM, required = false, defaultValue = ReportConstant.ONE_S) Integer pageNum,
                                                     @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.OPEN_PV_VO) String sortName,
                                                     @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        response.setHeader("Access-Control-Allow-Origin", "*");
    	//获取当前用户
    	User user = getUser(request, response);
        //声明并实例化结果集
        ResultModel<Page<AppCountVo>> resultModel = new ResultModel<Page<AppCountVo>>();
        try {
            //调用服务层
            resultModel.setReturnValue(appReportService.getAppCount(datetime, keyword, user,pageSize, pageNum, sortName, sortType));
        } catch (Exception e) {
            logger.error("查询开发者日报失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }


    /**
     * 分页查询开发者子链接
     *
     * @param datetime
     * @param keyword
     * @param appKey
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/business")
    @ResponseBody
    public ResultModel<Page<AppBusinessVo>> findAppBusinessCount(HttpServletResponse response,
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
            @RequestParam(name = ReportConstant.KEYWORD ,required = false)String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, required = false, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, required = false, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.OPEN_PV_VO) String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        //声明结果集
        //response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel<Page<AppBusinessVo>> resultModel = new ResultModel<Page<AppBusinessVo>>();
        try {
            //服务层调用
            resultModel.setReturnValue(appReportService.findAppBusinessCount(datetime, keyword, appKey, pageSize, pageNum, sortName, sortType));
        } catch (Exception e) {
            //异常情况
            logger.error("查询开发者日报按子链接失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        //返回结果
        return resultModel;
    }

    /**
     * 查询开发者日报按日
     * @param startTime
     * @param endTime
     * @param appKey
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/date")
    @ResponseBody
    public ResultModel<List<AppByDateVo>> findAppCountByDate(
            @RequestParam(name = ReportConstant.START_TIME) String startTime,
            @RequestParam(name = ReportConstant.END_TIME) String endTime,
            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
            @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        //声明结果集
        ResultModel<List<AppByDateVo>> resultModel = new ResultModel<>();
        try {
            //服务层调用
            resultModel.setReturnValue(appReportService.findAppCountDate(appKey, startTime, endTime, sortName, sortType));
        } catch (Exception e) {
            //异常情况
            logger.error("查询开发者日报按日失败"+e.getMessage(), e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        //返回结果集
        return resultModel;
    }

    /**
     * 查询开发者子链接按日
     * @param startTime
     * @param endTime
     * @param appKey
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/business/date")
    @ResponseBody
    public ResultModel<List<AppBusinessByDateVo>> findAppBusinessCountByDate(HttpServletResponse response,
            @RequestParam(name = ReportConstant.START_TIME) String startTime,
            @RequestParam(name = ReportConstant.END_TIME) String endTime,
            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
            @RequestParam(name = ReportConstant.BUSINESS) String business,
            @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        //声明结果集
        ResultModel<List<AppBusinessByDateVo>> resultModel = new ResultModel<>();
        try {
            //服务层调用
            resultModel.setReturnValue(appReportService.findAppBusinessCountByDate(appKey,business, startTime, endTime, sortName, sortType));
        } catch (Exception e) {
            //异常情况
            logger.error("查询开发者子链接按日失败"+e.getMessage(), e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        //返回结果集
        return resultModel;
    }

    /**
     * 查询开发者下面的广告券,其中，只传appkey,差的是开发者按广告券维度
     * 若appkey和Business都传，则查询的是子链接按馆告券维度
     * 其中json，是广告券ID 集合JSON，List<Long>
     * @param datetime
     * @param appKey
     * @param scene
     * @param keyword
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/ticket")
    @ResponseBody
    public ResultModel<Page<AppTicketVo>> findAppTicket(@RequestParam(name = ReportConstant.DATETIME) String datetime,
                                                        @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                                        @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
                                                        @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
                                                        @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
                                                        @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
                                                        @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
                                                        @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        //声明结果集
        ResultModel<Page<AppTicketVo>> resultModel = new ResultModel<Page<AppTicketVo>>();
        try {
            //服务层调用
            resultModel.setReturnValue(appReportService.findAppTicketCount(datetime, appKey,scene, keyword, pageSize, pageNum, sortName, sortType));

        } catch (Exception e) {
            //异常情况
            logger.error("查询开发者下面的广告券失败"+e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        //返回结果
        return resultModel;
    }


    /**
     * 分页查询开发者下面的广告券
     * 其中json，是广告券ID 集合JSON，List<Long>
     * @param startTime
     * @param endTime
     * @param appKey
     * @param certificateid
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/ticket/date")
    @ResponseBody
    public ResultModel<List<AppTicketDateVo>> findAppTicketDate(
                                                  @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                                  @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                                  @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                                                  @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
                                                  @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                                  @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        //声明结果集
        ResultModel<List<AppTicketDateVo>> resultModel = new ResultModel<List<AppTicketDateVo>>();
        try {
            //服务层调用
            resultModel.setReturnValue(appReportService.findAppTicketCountDate(startTime, endTime, appKey, certificateid, sortName, sortType));
        } catch (Exception e) {
            //异常情况
            logger.error("查询开发者下面的广告券按日失败"+e.getMessage(), e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        //返回结果
        return resultModel;
    }

    /**
     * 查询开发者子链接广告券
     * @param datetime
     * @param appKey
     * @param business
     * @param keyword
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/business/ticket")
    @ResponseBody
    public ResultModel<Page<AppBusinessTicketVo>> findAppBusinessTicket(
                              @RequestParam(name = ReportConstant.DATETIME) String datetime,
                              @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
                              @RequestParam(name = ReportConstant.BUSINESS) String business,
                              @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
                              @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
                              @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
                              @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
                              @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
                              @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        //声明结果集
        ResultModel<Page<AppBusinessTicketVo>> resultModel = new ResultModel<Page<AppBusinessTicketVo>>();
        try {
            //服务层调用
            resultModel.setReturnValue(appReportService.findAppBusinessTicketCount(datetime, appKey, business,scene,keyword, pageSize, pageNum, sortName, sortType));
        } catch (Exception e) {
            //异常情况
            logger.error("查询开发者子链接广告券失败"+e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        //返回结果
        return resultModel;
    }

    /**
     * 查询开发者子链接按活动
     * @param datetime
     * @param appKey
     * @param business
     * @param keyword
     * @param pageNum
     * @param pageSize
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/business/activity")
    @ResponseBody
    public ResultModel findAppBusinessActivity(
            @RequestParam(name = ReportConstant.DATETIME , required = false) String datetime,
            @RequestParam(name = ReportConstant.APPKEY_VO , required = false) String appKey,
            @RequestParam(name = ReportConstant.BUSINESS, required = false) String business,
            @RequestParam(name = ReportConstant.KEYWORD , required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_NUM, required = false) Integer pageNum,
            @RequestParam(name = ReportConstant.PAGE_SIZE, required = false) Integer pageSize,
            @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) throws IOException {

        return appReportService.findAppBusinessActivity(keyword,datetime,appKey,business,pageSize,pageNum,sortName,sortType);
    }


    /**
     * 开发者日报子链接中的广告位曝光数和广告位点击数编辑新增
     * @param iconPv
     * @param appKey
     * @param business
     * @param iconClickPv
     * @param dateTime
     * @return
     * @throws IOException
     */
    @RequestMapping("/app/update")
    @ResponseBody
    public ResultModel update(
            @RequestParam(name = "iconPv",required = false,defaultValue = ReportConstant.ZERO_S) String iconPv,
            @RequestParam(name = "iconClickPv",required = false,defaultValue = ReportConstant.ZERO_S) String iconClickPv,
            @RequestParam(name = ReportConstant.DATETIME) String dateTime,
            @RequestParam(name = ReportConstant.BUSINESS) String business,
            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey) {
        ResultModel resultModel = new ResultModel();
        resultModel.setSuccessed(false);
        try {

            int result = appReportService.updateIconOrClickPv(Integer.parseInt(iconPv), Integer.parseInt(iconClickPv), dateTime, business, appKey);
            if (result == 1) {
                resultModel.setSuccessed(true);
            }
            return resultModel;
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("编辑广告位曝光点击量失败" + e.getMessage(), e);
            return resultModel;
        }
    }


    /**
     * 查询开发者日报根据不同角色看到不同数据（bd只能看到自己的媒体）
     * @param startTime
     * @param startTime
     * @param keyword
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping("/app/appCountSumByDate")
    @ResponseBody
    public ResultModel findAppCountSumByDate(HttpServletRequest request,
                                             HttpServletResponse response,
                                             @RequestParam(name = ReportConstant.START_TIME) String startTime,
                                             @RequestParam(name = ReportConstant.END_TIME) String endTime,
                                             @RequestParam(name = ReportConstant.KEYWORD , required = false) String keyword,
                                             @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
                                             @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType,
                                             @RequestParam(name = ReportConstant.PAGE_NUM, required = false) Integer pageNum,
                                             @RequestParam(name = ReportConstant.PAGE_SIZE, required = false) Integer pageSize
    ){
        //获取当前用户
        User user = getUser(request, response);
        //声明并实例化结果集
        ResultModel<Page<AppCountVo>> resultModel = new ResultModel<Page<AppCountVo>>();
        try {
            //调用服务层
            resultModel.setReturnValue(appReportService.findAppCountSumByDate(startTime,endTime,keyword,user, sortName, sortType,pageNum,pageSize));
        } catch (Exception e) {
            logger.error("查询开发者日报失败" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }


}
