/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.controller.report;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.vo.report.OcpcOffersVo;
import com.bxm.adsmanager.model.vo.report.OcpcStatisticsVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.datapark.DataparkOcpcService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.convert.report.OcpcOffersConvert;
import com.bxm.adsmanager.web.convert.report.OcpcStatisticsConvert;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ocpc.OcpcOffers;
import com.bxm.datapark.facade.ocpc.OcpcOffersCondition;
import com.bxm.datapark.facade.ocpc.OcpcStatistics;
import com.bxm.datapark.facade.ocpc.OcpcStatisticsCondition;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
@RestController
@RequestMapping("/ocpc")
public class OcpcReportController {

    @Autowired
    private DataparkOcpcService dataparkOcpcService;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;

    @RequestMapping(value = "/find", method = RequestMethod.POST)
    public ResultModel<Page<OcpcStatisticsVo>> find(OcpcStatisticsCondition condition) {
        Page<OcpcStatistics> result = dataparkOcpcService.find(condition);

        List<OcpcStatisticsVo> voList = Lists.newArrayList();
        List<OcpcStatistics> list = result.getList();
        for (OcpcStatistics orig : list) {
            OcpcStatisticsVo vo = OcpcStatisticsConvert.convert(orig);
            Integer ticketid = orig.getTicketid();
            if (null != ticketid) {
                if (StringUtils.isNotBlank(orig.getPosition())) {
                    boolean closed = dataparkOcpcService.isClosed(String.valueOf(ticketid), orig.getPosition());
                    vo.setStatus(closed ? OcpcStatisticsVo.STATUS_CLOSED : OcpcStatisticsVo.STATUS_OPEN);
                }
                AdTicketOcpcConf conf = adTicketOcpcService.selectByTicketId(TypeHelper.castToLong(ticketid));
                if (null != conf) {
                    vo.setExpectCpa(conf.getCpaExpectPrice());
                }
            }
            voList.add(vo);
        }
        return ResultModelFactory.SUCCESS(new Page<OcpcStatisticsVo>(voList, result.getPageNum(), result.getPageSize(), result.getTotal()));
    }

    @RequestMapping(value = "/offers")
    public ResultModel<Page<OcpcOffersVo>> find(OcpcOffersConditionDto condition) {
        OcpcOffersCondition e = OcpcOffersConvert.convert(condition);
        List<OcpcOffersVo> voList = Lists.newArrayList();
        Page<OcpcOffers> result = dataparkOcpcService.find(e);
        List<OcpcOffers> offersList = result.getList();
        if (CollectionUtils.isEmpty(offersList)) {
            return ResultModelFactory.SUCCESS();
        }
        for (OcpcOffers ocpcOffers : offersList) {
            voList.add(OcpcOffersConvert.convert(ocpcOffers));
        }
        return ResultModelFactory.SUCCESS(new Page<OcpcOffersVo>(voList, result.getPageNum(), result.getPageSize(), result.getTotal()));
    }

    @RequestMapping("/reset")
    public ResultModel reset(String position, String ticketid) {
        try {
            dataparkOcpcService.reset(ticketid, position);
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            return ResultModelFactory.FAIL400(e.getMessage());
        }
    }

    public static class OcpcOffersConditionDto {

        private Integer ticketid;
        private String position;
        private String start;
        private String end;

        private Integer pageNum = 1;
        private Integer pageSize = 20;

        public Integer getTicketid() {
            return ticketid;
        }

        public void setTicketid(Integer ticketid) {
            this.ticketid = ticketid;
        }

        public String getPosition() {
            return position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public String getStart() {
            return start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public Integer getPageNum() {
            return pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}
