/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.controller.report;

import com.bxm.adsmanager.integration.datapark.model.DataParkContens;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.adsmanager.model.vo.report.*;
import com.bxm.adsmanager.service.datapark.DataparkTicketService;
import com.bxm.adsmanager.service.report.ITicketReportService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 广告券报表，控制层
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.report.TicketReportController.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:26:00
 * @modifier 阿导
 * @updated 2018-02-27 11:26:00
 */
@Controller
@RequestMapping("/report")
public class TicketReportController {

    private static final Logger logger = LoggerFactory.getLogger(AppReportController.class);

    @Autowired
    private DataparkTicketPullerIntegration dataparkTicketPullerIntegration;
    @Autowired
    private ITicketReportService ticketReportService;

    /**
     * 查询广告券日报小时维度
     * @param certificateid
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/ticketReportHour", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel ticketReportHour( @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       @RequestParam(name = DataParkContens.PAGE_SIZE, required = false) Integer pageSize,
                                       @RequestParam(name = DataParkContens.PAGE_NUM, required = false) Integer pageNum,
                                       @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                       @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        ResultModel resultModel = dataparkTicketPullerIntegration.TicketData(certificateid,null,null,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType);
        return resultModel;
    }


    /**
     * 查询广告券日报小时维度开发者
     * @param certificateid
     * @param appKey
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/ticketAppReportHour", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel ticketAppReportHour( @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       @RequestParam(name = DataParkContens.PAGE_SIZE, required = false) Integer pageSize,
                                       @RequestParam(name = DataParkContens.PAGE_NUM, required = false) Integer pageNum,
                                       @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                       @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        ResultModel resultModel = dataparkTicketPullerIntegration.TicketData(certificateid,appKey,null,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType);
        return resultModel;
    }

    /**
     * 查询广告券日报小时子渠道
     * @param certificateid
     * @param appKey
     * @param business
     * @param datetime
     * @param sHour
     * @param eHour
     * @param pageSize
     * @param pageNum
     * @param sortName
     * @param sortType
     * @return
     */
    @RequestMapping(value = "/ticketBusinessReportHour", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel ticketBusinessReportHour( @RequestParam(name = DataParkContens.CERTIFICATEID) Long certificateid,
                                       @RequestParam(name = DataParkContens.APP_KEY, required = false) String appKey,
                                       @RequestParam(name = DataParkContens.BUSINESS, required = false) String business,
                                       @RequestParam(name = DataParkContens.DATETIME) String datetime,
                                       @RequestParam(name = DataParkContens.S_HOUR, required = false) Integer sHour,
                                       @RequestParam(name = DataParkContens.E_HOUR, required = false) Integer eHour,
                                       @RequestParam(name = DataParkContens.PAGE_SIZE, required = false) Integer pageSize,
                                       @RequestParam(name = DataParkContens.PAGE_NUM, required = false) Integer pageNum,
                                       @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                       @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType) {
        ResultModel resultModel = dataparkTicketPullerIntegration.TicketData(certificateid,appKey,business,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType);
        return resultModel;
    }


    @RequestMapping("/ticket")
    @ResponseBody
    public ResultModel<Page<TicketCountVo>> findTicketCount(
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.SCENE, required = false) Integer scene,
            @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        ResultModel<Page<TicketCountVo>> resultModel = new ResultModel<Page<TicketCountVo>>();
        try {
            resultModel.setReturnValue(ticketReportService.findTicketCount(datetime,scene, keyword,pageNum, pageSize,sortName, sortType));
        } catch (Exception e) {
            logger.error("查询广告券维度失败：" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping("/ticket/app")
    @ResponseBody
    public ResultModel<Page<TicketAppVo>> findTicketAppCount(
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        ResultModel<Page<TicketAppVo>> resultModel = new ResultModel<Page<TicketAppVo>>();
        try {
            //开发者json
            resultModel.setReturnValue(ticketReportService.findTicketAppCount(datetime,certificateid, keyword,pageNum, pageSize,sortName, sortType));
        } catch (Exception e) {
            logger.error("查询广告券开发者维度维度失败：" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }


    @RequestMapping("/ticket/app/business")
    @ResponseBody
    public ResultModel<Page<TicketAppBusinessVo>> findTicketAppBusinessCount(
            @RequestParam(name = ReportConstant.DATETIME) String datetime,
            @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = ReportConstant.APPKEY_VO) String appKey,
            @RequestParam(name = ReportConstant.KEYWORD, required = false) String keyword,
            @RequestParam(name = ReportConstant.PAGE_SIZE, defaultValue = ReportConstant.TEN_S) Integer pageSize,
            @RequestParam(name = ReportConstant.PAGE_NUM, defaultValue = ReportConstant.ONE_S) Integer pageNum,
            @RequestParam(name = ReportConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) {
        ResultModel<Page<TicketAppBusinessVo>> resultModel = new ResultModel<Page<TicketAppBusinessVo>>();
        try {
            resultModel.setReturnValue(ticketReportService.findTicketAppBusinessCount(datetime,certificateid,appKey, keyword,pageNum, pageSize,sortName, sortType));
        } catch (Exception e) {
            logger.error("查询广告券开发者子链接维度失败：" + e.getMessage(), e);
            return ResultModelFactory.FAIL();
        }
        return resultModel;
    }

    @RequestMapping("/ticket/date")
    @ResponseBody
    public ResultModel<List<TicketDateVo>> findTicketCountDate(
            @RequestParam(name = ReportConstant.START_TIME) String startTime,
            @RequestParam(name = ReportConstant.END_TIME) String endTime,
            @RequestParam(name = ReportConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.DATETIME) String sortName,
            @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_ASC) String sortType) {
        //声明结果集
        ResultModel<List<TicketDateVo>> resultModel = new ResultModel<List<TicketDateVo>>();
        try {
            //服务层调用
            resultModel.setReturnValue(ticketReportService.findTicketCountDate(startTime, endTime, certificateid, sortName, sortType));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            //异常处理
            logger.error("广告券按日查询失败：" + e.getMessage(), e);
            resultModel.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
            resultModel.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        }
        //返回结果
        return resultModel;
    }

}
