package com.bxm.adsmanager.web.controller.test;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.service.adprofit.UpdateReportCashService;
import com.bxm.adsmanager.service.datapark.DataparkIncomeService;

/**
 * @FileName package com.bxm.adsmanager.web.controller.test.TestController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-11-30 14:14:00
 * @Modifier hcmony
 * @Updated 2017-11-30 14:14:00
 * @Description  做一些测试的使用
 * @Version BUILD1001
 */
@RestController
@RequestMapping("/test")
public class TestController {

	private static final Logger logger = Logger.getLogger(TestController.class);

	@Autowired
	private UpdateReportCashService updateReportCashService;
	@Autowired
	private DataparkIncomeService dataparkIncomeService;
	@Autowired
	private AdIncomeTicketService adIncomeTicketService;

	@RequestMapping(value = "/updateTicketCash", method = RequestMethod.GET)
	public void updateTicketCash(String datetime)throws Exception{
		updateReportCashService.updateReportCash(datetime);
	}

	@RequestMapping(value = "/updateAppCash", method = RequestMethod.GET)
	public void updateAppCash(String datetime)throws Exception{
		dataparkIncomeService.dealAppCash(datetime);
	}

	@RequestMapping(value = "/updatePositionTicketWeight", method = RequestMethod.GET)
	public void updatePositionTicketWeight(String ticketId)throws Exception{
		adIncomeTicketService.updatePositionTicketWeight(Long.valueOf(ticketId));
	}


}
