package com.bxm.adsmanager.web.controller.weight;

import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketCopyVo;
import com.bxm.adsmanager.model.vo.AdTicketWeightVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.annotation.before.LogBefore;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.weight.AdTicketWeightController.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-12 10:42:00
 * @modifier ganquan
 * @updated 2018-03-12 10:42:00
 */
@RestController
@RequestMapping(value = "/adTicket")
public class AdTicketWeightController extends BaseController {

    private static final Logger logger = Logger.getLogger(AdTicketWeightController.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketService adTicketService;

    /**
     * 获取到所有的广告主
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/queryAllAdvertiser", method = RequestMethod.GET)
    public ResultModel<Map<Integer,String>> queryAllAdvertiser(HttpServletRequest request, HttpServletResponse response) {

        response.setHeader("Access-Control-Allow-Origin", "*");

        ResultModel<Map<Integer,String>> rs = new ResultModel<>();
        try {
            Map<Integer, String> allAdvertiserMap = adShopIntegration.getAllAdvertiserMap();

            rs.setReturnValue(allAdvertiserMap);
        } catch (Exception e) {
            logger.error("获取广告主列表出错"+e.getMessage(), e);
        }
        return rs;
    }


    /**
     * 通过广告主查询礼券
     * @param advertiserId
     * @param ticketId
     * @param response
     * @return
     */
    @RequestMapping(value = "/queryTicketByAdvertiser", method = RequestMethod.GET)
    public ResultModel<List<AdTicketCopyVo>> queryTicketByAdvertiser(
            @RequestParam(value = "advertiserId",required = false) Integer advertiserId,
            @RequestParam(value = "ticketId",required = false) Integer ticketId,
            HttpServletResponse response) {

        response.setHeader("Access-Control-Allow-Origin", "*");
        //声明并实例化结果集
        ResultModel<List<AdTicketCopyVo>> rs = new ResultModel<List<AdTicketCopyVo>>();
        try {
            //得到结果集
            List<AdTicketCopyVo> ticketByAdvertiser = adTicketService.getTicketByAdvertiser(advertiserId,ticketId);
            //赋值
            rs.setReturnValue(ticketByAdvertiser);
        } catch (Exception e) {
            logger.error("获取广告券列表出错"+e.getMessage(), e);
        }
        return rs;
    }

    /**
     * 根据条件查询广告券
     * @param adTicketSearchDto
     * @param response
     * @return
     */
    @RequestMapping(value = "/queryTicketsByCondition", method = RequestMethod.GET)
    public ResultModel<PageInfo<AdTicketWeightVo>> queryTicketsByNameOrId(AdTicketSearchDto adTicketSearchDto,HttpServletResponse response) {

        response.setHeader("Access-Control-Allow-Origin", "*");

        //声明并实例化结果集
        ResultModel<PageInfo<AdTicketWeightVo>> rs = new ResultModel<PageInfo<AdTicketWeightVo>>();
        try {
            //得到结果集
            PageInfo<AdTicketWeightVo> adTicketWeightVoPage = adTicketService.queryTicketsByCondition(adTicketSearchDto);
            //赋值
            rs.setReturnValue(adTicketWeightVoPage);
        } catch (Exception e) {
            logger.error("根据条件查询广告券列表出错"+e.getMessage(), e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }

    /**
     * 根据条件查询广告主
     * @param ae
     * @param advertiserId
     * @param response
     * @return
     */
    @RequestMapping(value = "/queryAdvertiserByCondition", method = RequestMethod.GET)
    public ResultModel<List<AdTicketWeightVo>> queryAdvertiserByCondition(@RequestParam(value = "ae",required = false) String ae,
                                                                   @RequestParam(value = "advertiserId",required = false) Integer advertiserId,
                                                                   HttpServletResponse response) {

        response.setHeader("Access-Control-Allow-Origin", "*");

        //声明并实例化结果集
        ResultModel<List<AdTicketWeightVo>> rs = new ResultModel<List<AdTicketWeightVo>>();
        try {
            //得到结果集
            List<AdTicketWeightVo> adTicketWeightVos = adTicketService.queryAdvertiserByCondition(ae,advertiserId);
            //赋值
            rs.setReturnValue(adTicketWeightVos);
        } catch (Exception e) {
            logger.error("根据条件查询广告主列表出错"+e.getMessage(), e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }

    @RequestMapping(value = "/getAllAe", method = RequestMethod.GET)
    public ResultModel<List<AdTicketWeightVo>> getAllAe(HttpServletResponse response) {

        response.setHeader("Access-Control-Allow-Origin", "*");

        //声明并实例化结果集
        ResultModel<List<AdTicketWeightVo>> rs = new ResultModel<List<AdTicketWeightVo>>();
        try {
            //得到结果集
            List<AdTicketWeightVo> adTicketWeightVos = adTicketService.getAllAe();
            //赋值
            rs.setReturnValue(adTicketWeightVos);
        } catch (Exception e) {
            logger.error("根据条件查询广告主列表出错"+e.getMessage(), e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }

    /**
     * 根据广告券id修改权重
     * @param ticketId
     * @param interventionFactor
     * @param response
     * @return
     */
    @LogBefore(operType="/adTicket/updateInterventionFactor",keyName="权重")
    @RequestMapping(value = "/updateInterventionFactor", method = RequestMethod.POST)
    public ResultModel<Boolean> updateInterventionFactor(HttpServletRequest request, HttpServletResponse response,
            @RequestParam(value = "ticketId",required = true) Integer ticketId,
            @RequestParam(value = "interventionFactor",required = true) Double interventionFactor) {

        response.setHeader("Access-Control-Allow-Origin", "*");

        //声明并实例化结果集
        ResultModel<Boolean> rs = new ResultModel<Boolean>();
        try {
            String userName = getUser(request,response).getUsername();
            //赋值
            rs.setReturnValue(adTicketService.updateInterventionFactor(ticketId,interventionFactor,userName));
        } catch (Exception e) {
            logger.error("修改权重出错"+e.getMessage(), e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }



}
