package com.bxm.adsmanager.web.controller.weight;

import com.bxm.adsmanager.web.annotation.before.LogBefore;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.dto.mediamanager.PositionWeightDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.common.MediaPositionController;
import com.bxm.util.dto.ResultModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**  
* @Title: PositionTicketWeight 
* @Description:  媒体管理 更新广告位权重
* @author xavier  
* @date 2018年3月14日  
*/  
@RequestMapping("/positionTicketWeight")
@RestController
public class PositionTicketWeightController {

private static final Logger logger = Logger.getLogger(MediaPositionController.class);
	
	@Autowired
	private PositionTicketWeightService positionTicketWeightService;
	
	/**  
	 * @Title: findAll  
	 * @Description:  通过广告位ID查询权重
	 * @author xavier  
	 * @date 2018年3月14日
	 */  
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<Pagination> findAll(CommonSearchDto search) { 
		ResultModel<Pagination> rs = new ResultModel<Pagination>();
		if (StringUtils.isEmpty(search.getPositionId())) {
			rs.setSuccessed(false);
			rs.setErrorDesc("查询条件不能为空");
			return rs;
		}
		try {
			rs.setReturnValue(positionTicketWeightService.findAll(search));
		} catch (Exception e) {
			logger.error("媒体信息列表查询错误"+e.getMessage(), e);
			rs.setSuccessed(false);
			rs.setErrorDesc("媒体信息列表查询错误");
		}
		return rs;
	}
	
	/**  
	 * @Title: updatePostionWeight  
	 * @Description:  修改广告位权重值
	 * @author xavier  
	 * @date 2018年3月14日
	 */
	@LogBefore(operType="/positionTicketWeight/updatePositionWeight",keyName="广告")
	@RequestMapping(value = "/updatePositionWeight", method = RequestMethod.POST)
	public ResultModel<?> updatePositionWeight(HttpServletRequest request, HttpServletResponse response,
											   PositionWeightDto record) {
		//参数校验
		if (BeanValidator.validateGroup(record, PositionWeightDto.Update.class) != null) {
			return ResultModelFactory.FAIL400(BeanValidator.validateGroup(record,
					PositionWeightDto.Update.class).getMessage());
		}
		try {
			positionTicketWeightService.updatePositionWeight(record);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			logger.error("修改广告位权重值错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}
	
}
