/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.convert.report;

import com.bxm.adsmanager.model.vo.report.OcpcOffersVo;
import com.bxm.adsmanager.web.controller.report.OcpcReportController;
import com.bxm.datapark.facade.ocpc.OcpcOffers;
import com.bxm.datapark.facade.ocpc.OcpcOffersCondition;
import com.bxm.util.DateUtil;
import com.bxm.warcar.utils.DateHelper;
import org.apache.commons.lang.time.DateFormatUtils;

/**
 * @author allen
 * @since 1.0.0
 */
public final class OcpcOffersConvert {

    private OcpcOffersConvert() {}

    public static OcpcOffersVo convert(OcpcOffers ocpcOffers) {
        OcpcOffersVo dest = new OcpcOffersVo();
        dest.setBillid(ocpcOffers.getBillid());
        dest.setPrice(ocpcOffers.getPrice());
        dest.setValid(ocpcOffers.getValid());
        dest.setTime(DateUtil.dateTo14String(ocpcOffers.getTime()));
        return dest;
    }

    public static OcpcOffersCondition convert(OcpcReportController.OcpcOffersConditionDto dto) {
        OcpcOffersCondition dest = new OcpcOffersCondition();
        dest.setTicketid(dto.getTicketid());
        dest.setPosition(dto.getPosition());
        dest.setPageNum(dto.getPageNum());
        dest.setPageSize(dto.getPageSize());
        dest.setStart(DateUtil.convertStr3Date(dto.getStart()));
        dest.setEnd(DateUtil.convertStr3Date(dto.getEnd()));
        return dest;
    }
}
