package com.bxm.adsmanager.web.interceptor;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.alibaba.fastjson.JSONArray;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.auth.ValidationService;
import com.bxm.adsmanager.service.auth.impl.ValidationServiceImpl;
import com.bxm.adsmanager.utils.IPUtils;
import com.bxm.adsmanager.web.controller.base.BaseController;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <h3>权限拦截</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/15 18:13
 */
@Configuration
public class AuthInterceptor extends HandlerInterceptorAdapter {

	private final Logger logger                         = Logger.getLogger(AuthInterceptor.class);
	private String AUTH_KEY_PRE = "AD:AUTH:";

	@Autowired
	private ValidationService validationService;

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
							 Object handler) throws Exception {

		String token = request.getHeader("token");
		String ip = IPUtils.getIp(request);
		//假如无法注入的情况下
		if(validationService==null){
			BeanFactory factory = WebApplicationContextUtils.getRequiredWebApplicationContext(request.getServletContext());
			validationService = (ValidationServiceImpl) factory.getBean("validationServiceImpl");
		}

		//todo 为了测试
		String testOnOff = (String) validationService.testOnOff();
		if(testOnOff!=null){
			User user = JSONArray.parseObject(testOnOff,User.class);
			request.getSession().setAttribute(BaseController.SESSION_USER_NAME,user);
			return  true;
		}

		if(token==null){
			request.getRequestDispatcher("/notLogin").forward(request,response);
			return false;
		}

		token = AUTH_KEY_PRE+token;
		String result  = (String) validationService.verifyAccessToken(token);
		if(result==null){
			request.getRequestDispatcher("/noAuth").forward(request,response);
			return false;
		}

		User user = JSONArray.parseObject(result,User.class);
		request.getSession().setAttribute(BaseController.SESSION_USER_NAME,user);
		logger.info("用户权限验证成功user:"+user.getUsername()+",ip:"+ip+",访问内容:"+request.getRequestURI());
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
						   ModelAndView modelAndView) throws Exception {
		// log.info("在Controller请求处理之后进行调用，但是在视图被渲染之前");
	}

	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
								Exception ex) throws Exception {
		// log.info("在整个请求结束之后被调用，也就是在DispatcherServlet渲染了对应的视图之后执行（主要是用于进行资源清理工作）");
	}
}
