package com.bxm.adsmanager.web.interceptor;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/15 18:13
 */
public class LoginInterceptor implements HandlerInterceptor {

    private final Logger logger                         = Logger.getLogger(LoginInterceptor.class);
    private final String SESSION_LOGIN_KEY              = "session_login_key";
    private final int LOGIN_SESSION_EFFECTIVE_TIME      = 60 * 60 * 1; // 一小时
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
                             Object handler) throws Exception {
        // log.info("在Controller请求处理之前进行调用");
        HttpSession session = request.getSession();
        Object obj = session.getAttribute(SESSION_LOGIN_KEY);
        // 只有返回true才会继续向下执行，返回false取消当前请求
        // 跳转到登录页面
        if (obj == null) {
            logger.info("用户未登录 user not login......");
            response.sendRedirect("/");
            return false;
        }
        // 继续执行程序
        else {
            logger.info("用户已登录 user is logined......");
            // 更新失效时间
            session.setMaxInactiveInterval(LOGIN_SESSION_EFFECTIVE_TIME);
            return true;
        }

    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {
        // log.info("在Controller请求处理之后进行调用，但是在视图被渲染之前");
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                Exception ex) throws Exception {
        // log.info("在整个请求结束之后被调用，也就是在DispatcherServlet渲染了对应的视图之后执行（主要是用于进行资源清理工作）");
    }
}
