package com.bxm.adsmanager.web;

import com.bxm.openlog.sdk.listener.EnableLogSubscriberFactory;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import com.bxm.warcar.integration.autoconfigure.distributed.EnableDistributedScheduling;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import redis.clients.jedis.JedisPool;

@SpringBootApplication
@EnableFeignClients({
        "com.bxm.adapi.facade",
        "com.bxm.profit.facade",
        "com.bxm.log.facade",
        "com.bxm.adsmanager.integration.advertiser.service",
        "com.bxm.datapark.facade",
        "com.bxm.datapark.web",
        "com.bxm.acl.facade",
        "com.bxm.adsmedia.facade",
        "com.bxm.adsmanager.integration.adsmedia",
        "com.bxm.activites.facade",
        "com.bxm.mccms.facade.service",
        "com.bxm.activities.service"
})
@EnableDiscoveryClient
@MapperScan(basePackages = "com.bxm.adsmanager.dal.mapper")
@ImportResource({"classpath:application-domain.xml"})
@EnableLogSubscriberFactory
@EnableDistributedScheduling
public class AdsManagerApplication {

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(AdsManagerApplication.class);
        application.addListeners(new SpringBootEnvironmentListener());
        application.run(args);
    }

    @Bean
    public CorsFilter corsFilter() {

        final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        final CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true); // 允许cookies跨域
        config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
        config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        config.addAllowedMethod("OPTIONS");// 允许提交请求的方法，*表示全部允许
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");// 允许Get的请求方法
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        //
        return new CorsFilter(source);
    }

    @Bean
    @LoadBalanced
    public RestTemplate restTemplate() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(5000);
        simpleClientHttpRequestFactory.setReadTimeout(120000);
        return new RestTemplate(simpleClientHttpRequestFactory);
    }


    @Autowired
    private JedisConfiguration configuration;

//    @Bean
//    public RedisCache redisCache(){
//        return new LocalCache(jedisPool(),1, TimeUnit.MINUTES);
//    }

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }
}
