package com.bxm.adsmanager.web.config;

import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.advertiser.service.AdvertiserFeignService;
import com.bxm.adsmanager.scheduler.AdvertiserSynchronizingPushable;
import com.bxm.adsmanager.scheduler.PositionSynchronizingPushable;
import com.bxm.adsmedia.facade.service.AppEntranceFacadeService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.zk.ZkClientHolder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-09-14
 * @since 1.0
 */
@Configuration
public class AutomaticPushableAutoConfiguration {

    @Bean
    public PositionSynchronizingPushable positionSynchronizingPushable(AppEntranceFacadeService appEntranceFacadeService, ProdPusherIntegration prodPusher,
                                                                       Fetcher fetcher, Updater updater, ZkClientHolder zkClientHolder) {
        return new PositionSynchronizingPushable(appEntranceFacadeService, prodPusher, fetcher, updater, zkClientHolder);
    }

    @Bean
    public AdvertiserSynchronizingPushable advertiserSynchronizingPushable(AdvertiserFeignService advertiserFeignService, ProdPusherIntegration prodPusher,
                                                                           Fetcher fetcher, Updater updater, ZkClientHolder zkClientHolder) {
        return new AdvertiserSynchronizingPushable(advertiserFeignService, prodPusher, fetcher, updater, zkClientHolder);
    }
}
