package com.bxm.adsmanager.web.config;

import com.bxm.warcar.integration.pair.redis.RedisPairImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;


@Configuration
@EnableConfigurationProperties(PairRedisConfiguration.class)
public class PairRedisBeanConfiguration {

    private final PairRedisConfiguration pairRedisConfiguration;

    public PairRedisBeanConfiguration(PairRedisConfiguration pairRedisConfiguration) {
        this.pairRedisConfiguration = pairRedisConfiguration;
    }

    @Bean
    public JedisPool jedisPoolForPair() {
        return new JedisPool(pairRedisConfiguration, pairRedisConfiguration.getHost(), pairRedisConfiguration.getPort(), pairRedisConfiguration.getTimeout(),
                pairRedisConfiguration.getPassword(), pairRedisConfiguration.getDatabase());
    }

    @Bean
    public RedisPairImpl customeRedisPairImpl() {
        return new RedisPairImpl(jedisPoolForPair());
    }


}

