package com.bxm.adsmanager.web.controller.abtest;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.abtest.AbTestDictionariesVo;
import com.bxm.adsmanager.model.vo.audit.RefuseConfigVo;
import com.bxm.adsmanager.service.abtest.AbTestDictionariesService;
import com.bxm.adsmanager.service.audit.RefuseService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/abtest")
public class AbTestDictionariesController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbTestDictionariesController.class);

    @Autowired
    AbTestDictionariesService abTestDictionariesService;

    @RequestMapping(value = "/dictionaries/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "algorithmName") String algorithmName) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            abTestDictionariesService.add(algorithmName, user.getUsername());
            //日志记录
            //addLogs(user, "新增算法字典的名字为：" + algorithmName, "算法");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增算法字典出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }


    @RequestMapping(value = "/dictionaries/update", produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "algorithmName") String algorithmName,
                              @RequestParam(value = "algorithmCode") Integer algorithmCode) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            abTestDictionariesService.update(algorithmName, algorithmCode, user.getUsername());
            //日志记录
            //addLogs(user, "修改算法字典的名字为：" + algorithmName + "，算法code是：" + algorithmCode, "算法");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改算法字典出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/dictionaries/getPageList", produces = "application/json")
    public ResultModel<PageInfo<AbTestDictionariesVo>> getPageList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "algorithmName",required = false) String algorithmName,
            @RequestParam(value = "algorithmCode",required = false) String algorithmCode) {
        ResultModel<PageInfo<AbTestDictionariesVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(abTestDictionariesService.getPageList(algorithmName, algorithmCode,pageNum,pageSize));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找算法字典列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找算法字典列表出错");
        }
        return resultModel;
    }

    @RequestMapping(value = "/dictionaries/getList", produces = "application/json")
    public ResultModel<List<AbTestDictionariesVo>> getList(
            @RequestParam(value = "algorithmName",required = false) String algorithmName,
            @RequestParam(value = "algorithmCode",required = false) String algorithmCode) {
        ResultModel<List<AbTestDictionariesVo>> resultModel = new ResultModel<>();
        try {
            List<AbTestDictionariesVo> list=abTestDictionariesService.getPageList(algorithmName, algorithmCode,1,Integer.MAX_VALUE).getList();
            resultModel.setReturnValue(list);
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找算法字典列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找算法字典列表出错");
        }
        return resultModel;
    }
}
