package com.bxm.adsmanager.web.controller.abtest;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.abtest.AbTestDictionariesVo;
import com.bxm.adsmanager.model.vo.abtest.AbTestSceneVo;
import com.bxm.adsmanager.service.abtest.AbTestDictionariesService;
import com.bxm.adsmanager.service.abtest.AbTestSceneService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2019-01-04 11:48:00
 * @modifier 拉拉
 * @updated 2019-01-04 11:48:00
 */
@RestController
@RequestMapping("/abtest")
public class AbTestSceneController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbTestSceneController.class);

    @Autowired
    AbTestSceneService abTestSceneService;

    @RequestMapping(value = "/scene/add", produces = "application/json")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestParam(value = "sceneName") String sceneName,
                           @RequestParam(value = "defaultAlgorithmCode")String defaultAlgorithmCode) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            abTestSceneService.add(sceneName,defaultAlgorithmCode, user.getUsername());
            //日志记录
            addLogs(user, "新增 业务场景的名字为：" + sceneName +",默认默认算法code是："+defaultAlgorithmCode, "业务场景");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("新增业务场景出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }


    @RequestMapping(value = "/scene/update", produces = "application/json")
    public ResultModel update(HttpServletRequest request, HttpServletResponse response,
                              @RequestParam(value = "sceneName") String sceneName,
                              @RequestParam(value = "sceneCode") String sceneCode,
                              @RequestParam(value = "defaultAlgorithmCode")String defaultAlgorithmCode) {
        try {
            // 获取后台用户名
            User user = getUser(request, response);
            abTestSceneService.update(sceneName,sceneCode, defaultAlgorithmCode, user.getUsername());
            //日志记录
            addLogs(user, "修改业务场景的名字为：" + sceneName + "，默认算法code是：" + defaultAlgorithmCode, "业务场景");
            return ResultModelFactory.SUCCESS();
        } catch (Exception e) {
            LOGGER.error("修改业务场景出错", e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @RequestMapping(value = "/scene/getPageList", produces = "application/json")
    public ResultModel<PageInfo<AbTestSceneVo>> getPageList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "sceneKeywords",required = false) String sceneKeywords) {
        ResultModel<PageInfo<AbTestSceneVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(abTestSceneService.getPageList(sceneKeywords,pageNum,pageSize));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找业务场景列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找业务场景列表出错");
        }
        return resultModel;
    }

    @RequestMapping(value = "/scene/getList", produces = "application/json")
    public ResultModel<List<AbTestSceneVo>> getList(
            @RequestParam(value = "sceneKeywords",required = false) String sceneKeywords) {
        ResultModel<List<AbTestSceneVo>> resultModel = new ResultModel<>();
        try {
            List<AbTestSceneVo> list =abTestSceneService.getList(sceneKeywords);
            resultModel.setReturnValue(list);
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            LOGGER.error("查找业务场景列表出错", e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查找业务场景列表出错");
        }
        return resultModel;
    }
}
